% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tissue.data}
\alias{tissue.data}
\title{Tissue composition and species-specific physiology parameters}
\format{
A data.frame containing 406 rows and 5 columns.
\tabular{ll}{
\strong{Column} \tab \strong{Description} \cr
Tissue \tab The tissue being described \cr                      
Species \tab The species being described \cr                      
Reference \tab The reference for the value reported \cr                      
variable \tab The aspect of the tissue being characterized \cr                      
value \tab The value for the variable for the given tissue and species \cr                      
}
}
\usage{
tissue.data
}
\description{
This data set contains values from Schmitt (2008) and Ruark et al. (2014)
describing the composition of specific tissues and from Birnbaum et al.
(1994) describing volumes of and blood flows to those tissues, allowing
parameterization of toxicokinetic models for human, mouse, rat, dog, or
rabbit. Tissue volumes were calculated by converting the fractional mass of
each tissue with its density (both from ICRP), lumping the remaining tissues
into the rest-of-body, excluding the mass of the gastrointestinal contents.
}
\details{
Many of the parameters were compiled initially in Table 2 of Schmitt (2009).
The full list of tissue variables described is:
\tabular{lll}{
\strong{Variable} \tab \strong{Description} \tab \strong{Units} \cr
Fcell \tab Cellular fraction of total tissue volume \tab fraction \cr
Fint \tab Interstitial fraction of total tissue volume \tab fraction \cr
FWc \tab Fraction of cell volume that is water \tab fraction \cr
FLc \tab Fraction of cell volume that is lipid \tab fraction \cr
FPc \tab Fraction of cell volume that is protein \tab fraction \cr
Fn_Lc \tab Fraction of cellular lipid tht is neutral lipid \tab fraction \cr
Fn_PLc \tab Fraction of cellular lipid tht is neutral phospholipid \tab fraction \cr
Fa_PLc \tab Fraction of cellular lipid tht is acidic phospholipid \tab fraction \cr
pH \tab Negative logarithm of H+ ion concentration \tab unitless\cr
Density \tab Tissue density \tab g/cm^3 \cr
Vol \tab Tissue volume \tab L/kg \cr
Flow \tab Blood flow to tissue \tab mL/min/kg^(3/4) \cr
}

New tissues can be added to this table to generate
their partition coefficients.
}
\examples{
# We can add thyroid to the tissue data by making a row containing
# its data, subtracting the volumes and flows from the rest-of-body, 
# and binding the row to tissue.data. Here we assume it contains the same 
# partition coefficient data as the spleen and a tenth of the volume and  
# blood flow:
new.tissue <- subset(tissue.data,Tissue == "spleen")
new.tissue[, "Tissue"] <- "thyroid"
new.tissue[new.tissue$variable \%in\% c("Vol (L/kg)",
"Flow (mL/min/kg^(3/4))"),"value"] <- new.tissue[new.tissue$variable
\%in\% c("Vol (L/kg)","Flow (mL/min/kg^(3/4))"),"value"] / 10
tissue.data[tissue.data$Tissue == "rest", "value"] <-
tissue.data[tissue.data$Tissue == "rest", "value"] -
new.tissue[new.tissue$variable \%in\% c("Vol (L/kg)",
"Flow (mL/min/kg^(3/4))"),"value"]
tissue.data <- rbind(tissue.data, new.tissue)

}
\references{
\insertRef{birnbaum1994physiological}{httk}

\insertRef{ruark2014predicting}{httk}

\insertRef{schmitt2008general}{httk}

\insertRef{snyder1974report}{httk}

\insertRef{wambaugh2015toxicokinetic}{httk}
}
\seealso{
\code{\link{predict_partitioning_schmitt}}
}
\author{
John Wambaugh, Robert Pearce, and Nisha Sipes
}
\keyword{data}
