% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hte_plot_line.R
\name{hte_plot_line}
\alias{hte_plot_line}
\title{Visualize the Estimated Results}
\usage{
hte_plot_line(
  model,
  data,
  treatment_indicator = NULL,
  outcomevariable,
  propensity_score,
  plot.title = "Visualization of the Tree",
  gamma = 0,
  lambda = 0,
  ...
)
}
\arguments{
\item{model}{a tree model constructed by \code{hte_causalTree, hte_matchinleaves,
or hte_ipw}.}

\item{data}{a data frame containing the variables in the model.}

\item{treatment_indicator}{a character representing the column name
for the treatment variable in the causal setup.}

\item{outcomevariable}{a character representing the column name
of the outcome variable.}

\item{propensity_score}{a character representing the column name of
the propensity score.}

\item{plot.title}{character representing the main title of the plot.}

\item{gamma, lambda}{numbers indicating the bias level used in
sensitivity analysis}

\item{...}{further arguments passed to or from other methods.}
}
\value{
No return value, used for plotting the estimated results
with lines.
}
\description{
The function \code{hte_plot_line} takes a model created by
causal tree, as well as the adjusted version, and plots the
different least squares models used to estimate heterogeneous
treatment effects(HTE) at each node.  At each node, this
visualization aims to show how the estimated treatment effect
differs when using ordinary least squares and weighted least
squares methods. The weighted least squares method in this
package uses
inverse propensity scores as weights, in order to reduce
bias due to confounding variables.
}
