% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.seriesaccuracy}
\alias{plot.seriesaccuracy}
\title{Plot method for `seriesaccuracy` object}
\usage{
\method{plot}{seriesaccuracy}(x, return_plot = FALSE, ...)
}
\arguments{
\item{x}{Object of class `hpiaccuracy``}

\item{return_plot}{default = FALSE; Return the plot to the function call}

\item{...}{Additional argument (passed to `plot.hpiaccuracy()``)}
}
\value{
`plotaccuracy` object inheriting from a ggplot object
}
\description{
Specific plotting method for seriesaccuracy objects
}
\examples{

 # Load data
 data(ex_sales)

 # Create index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 #  Create Series (Suppressing messages do to small sample size of this example)
 suppressMessages(
    hpi_series <- createSeries(hpi_obj = rt_index,
                               train_period = 12))

 # Calculate insample accuracy
 hpi_series_accr <- calcSeriesAccuracy(series_obj = hpi_series,
                                       test_type = 'rt',
                                       test_method = 'insample')
 # Make Plot
 plot(hpi_series_accr)

}
