% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{howlerButton}
\alias{howlerButton}
\alias{howlerPlayButton}
\alias{howlerPauseButton}
\alias{howlerPlayPauseButton}
\alias{howlerStopButton}
\alias{howlerBackButton}
\alias{howlerForwardButton}
\alias{howlerPreviousButton}
\alias{howlerNextButton}
\alias{howlerVolumeUpButton}
\alias{howlerVolumeDownButton}
\alias{howlerVolumeToggleButton}
\title{Audio Buttons}
\usage{
howlerButton(howler_id, button_type = HOWLER_BUTTON_TYPES, ...)

howlerPlayButton(howler_id)

howlerPauseButton(howler_id)

howlerPlayPauseButton(howler_id)

howlerStopButton(howler_id)

howlerBackButton(howler_id, seek_change = 10)

howlerForwardButton(howler_id, seek_change = 10)

howlerPreviousButton(howler_id)

howlerNextButton(howler_id)

howlerVolumeUpButton(howler_id, volume_change = 0.1)

howlerVolumeDownButton(howler_id, volume_change = 0.1)

howlerVolumeToggleButton(howler_id)
}
\arguments{
\item{howler_id}{ID given to the \code{\link{howler}} player.}

\item{button_type}{Type of button to create. Available buttons are in the details, default set to \code{play_pause}.}

\item{...}{Attributes/Inner tags added to the button}

\item{seek_change}{Time (in seconds) to move forward/backward the track when clicked. Default is 10 seconds}

\item{volume_change}{How much to change the volume by. Default is 10\%.}
}
\value{
An HTML tag containing the audio button.

An additional input will be available in the server side in the form \code{\{id\}_\{button_type\}}. For example
\code{howlerBackButton("howler")} will create an input element of \code{input$howler_back}. All of these will work in
the same way as \code{\link[shiny]{actionButton}}
}
\description{
Buttons that can be used to interact with the \code{\link{howler}}.

\code{howlerPlayButton}, \code{howlerPauseButton}, \code{howlerPlayPauseButton} and
\code{howlerStopButton} will all be applied to the current track.

\code{howlerBackButton} and \code{howlerForwardButton} will
change the track position by a specified amount of time.

\code{howlerPreviousButton} and \code{howlerNextButton} will
play the previous/following track supplied to the player.

\code{howlerVolumeDownButton} and \code{howlerVolumeUpButton} will
change the volume of the player by a specified percentage.

\code{howlerButton} is a customisable version of any of the above individual button.
}
\details{
The following \code{button_type} are available to create:

\describe{
\item{\code{play_pause}}{(default) Switch between playing and pausing the track}
\item{\code{play}}{Resumes the current track}
\item{\code{pause}}{Pauses the current track}
\item{\code{stop}}{Stops current track, when played will start from beginning}
\item{\code{previous},\code{next}}{Switches to the previous/following track}
\item{\code{volumedown},\code{volumeup}}{Decreases/Increases the volume by 10\%
(If using \code{howlerButton} include the attribute \code{`data-volume-change`})}
\item{\code{back},\code{forward}}{Seek forward/backwards 10s
(If using \code{howlerButton} include the attribute \code{`data-seek-change`} with negative values to go backwards)}
}

When using a \code{play_pause} button, the icon will toggle between the play and pause button
depending on whether or not the track is playing.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    tile = "howler.js Player",
    howler(elementId = "howler", "audio/sound.mp3"),
    howlerPreviousButton("howler"),
    howlerBackButton("howler"),
    howlerPlayPauseButton("howler"),
    howlerForwardButton("howler"),
    howlerNextButton("howler"),
    howlerVolumeDownButton("howler"),
    howlerVolumeUpButton("howler")
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}

}
