% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingheterogeneity.R
\name{getCutPoints}
\alias{getCutPoints}
\title{Calculate the threshold cut-points and individual adjusted responses using Jurges' method}
\usage{
getCutPoints(model, decreasing.levels = model$decreasing.levels, subset = NULL)
}
\arguments{
\item{model}{a fitted \code{hopit} model.}

\item{decreasing.levels}{a logical indicating whether self-reported health classes are ordered in increasing order.}

\item{subset}{an optional vector specifying a subset of observations.}
}
\value{
a list with the following components:
\item{cutpoints}{ cut-points for the adjusted categorical response levels with the corresponding percentiles of the latent index.}
\item{adjusted.levels}{ adjusted categorical response levels for each individual.}
}
\description{
Calculate the threshold cut-points and individual adjusted responses using Jurges' method
}
\examples{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fit a model
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# calculate the health index cut-points
z <- getCutPoints(model = model1)
z$cutpoints

plot(z)

# tabulate the adjusted health levels for individuals (Jurges method):
rev(table(z$adjusted.levels))

# tabulate the original health levels for individuals
table(model1$y_i)

# tabulate the predicted health levels
table(model1$Ey_i)
}
\references{
\insertRef{Jurges2007}{hopit}\cr\cr
\insertRef{OKSUZYAN2019}{hopit}
}
\seealso{
\code{\link{latentIndex}}, \code{\link{standardiseCoef}}, \code{\link{getLevels}}, \code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
