% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\name{plot_sealevel}
\alias{plot_sealevel}
\title{Download and plot essential climate data}
\usage{
plot_sealevel(dataset = get_sealevel(), print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_sealevel}, defaults to calling \code{get_sealevel}}

\item{print}{(boolean) Display sealevel ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with sealevel chart
}
\description{
Plots the global mean sea level data retrieved using \code{get_sealevel()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_sealevel} invisibly returns a ggplot2 object with a pre-defined sealevel change chart using data from \code{get_sealevel}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch sealevel data:
gmsl <- get_sealevel()
#
# Plot output using package's built-in ggplot2 defaults
plot_sealevel(gmsl)

# Or just call plot_sealevel(), which defaults to get_sealevel() dataset
plot_sealevel()

p <- plot_sealevel(gmsl, print = FALSE)
p + ggplot2::labs(title='Rising Waters') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
