% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_on_ice.R
\name{calculate_on_ice}
\alias{calculate_on_ice}
\title{Calculate player on-ice stats}
\usage{
calculate_on_ice(pbp, type = c("R", "P"), game_strength = "all")
}
\arguments{
\item{pbp}{A tibble of play-by-play data, typically returned from either
\code{\link{load_pbp}} or \code{\link{scrape_game}}}

\item{type}{Season type to filter by; "R" for regular season and/or "P" for postseason}

\item{game_strength}{String or vector of strings defining strength state to
filter by; ex c("3v5","4v5","3v4") returns stats for shorthanded strength}
}
\value{
A tibble containing on-ice shot stats for all players in supplied pbp data.
\strong{These stats are for all players in which a player was on the ice, not individual stats.}
For help with individual stats, please see \code{\link{calculate_individual}}.
On-ice stats include:
\describe{
\item{player_name}{String identifying player name}
\item{player_id}{Integer value of the NHL player ID}
\item{team}{String identifying player's most recent team}
\item{gp}{Games Played}
\item{cf}{Numeric shot attempts (Corsi) for}
\item{ca}{Numeric shot attempts (Corsi) against}
\item{cf_perc}{Numeric Corsi For \% (CF\%)}
\item{ff}{Numeric unblocked shot attempts (Fenwick) for}
\item{fa}{Numeric unblocked shot attempts (Fenwick) against}
\item{ff_perc}{Numeric Fenwick For \% (FF\%)}
\item{gf}{Numeric goals for}
\item{ga}{Numeric goals against}
\item{gf_perc}{Numeric Goals For \% (GF\%)}
\item{xgf}{Numeric expected goals for}
\item{xga}{Numeric expected goals against}
\item{xgf_perc}{Numeric Expected Goals For \% (xGF\%)}
}
If supplied play-by-play data includes shift change events (the default for \code{\link{scrape_game}};
if using \code{\link{load_pbp}} user must set \code{shift_events} argument to \code{TRUE}) then
the following rate stats will also be calculated:
\describe{
\item{toi}{String description of total time on ice in 'minutes:seconds'}
\item{mean_toi}{String description of average time on ice over all supplied games, in 'minutes:seconds'}
\item{toi_minutes}{Numeric total time on ice, in minutes}
\item{mean_toi_minutes}{Numeric average time on ice over all supplied games, in minutes}
\item{cf_per60}{Numeric shot attempts (Corsi) for per 60 minutes}
\item{ca_per60}{Numeric shot attempts (Corsi) against per 60 minutes}
\item{ff_per60}{Numeric unblocked shot attempts (Fenwick) for per 60 minutes}
\item{fa_per60}{Numeric unblocked shot attempts (Fenwick) against per 60 minutes}
\item{gf_per60}{Numeric goals for per 60 minutes}
\item{ga_per60}{Numeric goals against per 60 minutes}
\item{xgf_per60}{Numeric expected goals for per 60 minutes}
\item{xga_per60}{Numeric expected goals against per 60 minutes}
}
}
\description{
Calculate player on-ice stats
}
\examples{
\dontrun{
#load pbp
pbp_2022 <- load_pbp(2022, shift_events = TRUE)
player_stats <- calculate_on_ice(pbp_2022, type = "R", game_strength = "5v5")
}
}
