% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hms.R
\name{hms}
\alias{hms}
\alias{is.hms}
\alias{as.hms}
\alias{as.hms.default}
\alias{as.hms.difftime}
\alias{as.hms.numeric}
\alias{as.hms.character}
\alias{as.hms.POSIXt}
\alias{as.hms.POSIXlt}
\alias{as.POSIXct.hms}
\alias{as.POSIXlt.hms}
\alias{as.character.hms}
\alias{as.data.frame.hms}
\alias{format.hms}
\alias{print.hms}
\title{A simple class for storing time-of-day values}
\usage{
hms(seconds = NULL, minutes = NULL, hours = NULL, days = NULL)

is.hms(x)

as.hms(x, ...)

\method{as.hms}{default}(x, ...)

\method{as.hms}{difftime}(x, ...)

\method{as.hms}{numeric}(x, ...)

\method{as.hms}{character}(x, ...)

\method{as.hms}{POSIXt}(x, tz = pkgconfig::get_config("hms::default_tz", ""),
  ...)

\method{as.hms}{POSIXlt}(x, tz = pkgconfig::get_config("hms::default_tz", ""),
  ...)

\method{as.POSIXct}{hms}(x, ...)

\method{as.POSIXlt}{hms}(x, ...)

\method{as.character}{hms}(x, ...)

\method{as.data.frame}{hms}(x, row.names = NULL, optional = FALSE, ...,
  nm = paste(deparse(substitute(x), width.cutoff = 500L), collapse = " "))

\method{format}{hms}(x, ...)

\method{print}{hms}(x, ...)
}
\arguments{
\item{seconds, minutes, hours, days}{Time since midnight. No bounds checking is
performed.}

\item{x}{An object.}

\item{...}{Arguments passed on to further methods.}

\item{tz}{The time zone in which to interpret a POSIXt time for extracting
the time of day.  The default is now the zone of \code{x} but was \code{"UTC"}
for v0.3 and earlier.  The previous behavior can be restored by calling
\code{pkgconfig::set_config("hms::default_tz", "UTC")}, see
\code{\link[pkgconfig:set_config]{pkgconfig::set_config()}}.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link{data.frame}(*, check.names = !optional)}.}

\item{nm}{Name of column in new data frame}
}
\description{
The values are stored as a \link{difftime} vector with a custom class,
and always with "seconds" as unit for robust coercion to numeric.
Supports construction from time values, coercion to and from
various data types, and formatting.  Can be used as a regular column in a
data frame.
}
\details{
For \code{hms}, all arguments must have the same length or be
\code{NULL}.  Odd combinations (e.g., passing only \code{seconds} and
\code{hours} but not \code{minutes}) are rejected.
}
\examples{
hms(56, 34, 12)
hms()
as.hms(1)
as.hms("12:34:56")
as.hms(Sys.time())
as.POSIXct(hms(1))
data.frame(a = hms(1))
d <- data.frame(hours = 1:3)
d$hours <- hms(hours = d$hours)
d
}
