% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticplots.R
\name{effect_strength}
\alias{effect_strength}
\title{Find Effect Strength of Active Variables}
\usage{
effect_strength(
  ems,
  plt = interactive(),
  line.plot = FALSE,
  grid.plot = FALSE,
  labels = TRUE,
  quadratic = TRUE,
  xvar = TRUE
)
}
\arguments{
\item{ems}{The Emulator object(s) to be analysed.}

\item{plt}{Should the results be plotted?}

\item{line.plot}{Should a line plot be produced?}

\item{grid.plot}{Should the effect strengths be plotted as a grid?}

\item{labels}{Whether or not the legend should be included.}

\item{quadratic}{Whether or not quadratic effect strength should be calculated.}

\item{xvar}{Should the inputs be used on the x-axis?}
}
\value{
A list of data.frames: the first is the linear strength, and the second quadratic.
}
\description{
Collates the linear and quadratic contributions of the active variables to the global
emulators' behaviour
}
\details{
For a set of emulators, it can be useful to see the relative contributions of various
parameters to the global part of the emulator (i.e. the regression surface). This
function extracts the relevant information from a list of emulator objects.

The parameter \code{quadratic} controls whether quadratic effect strength is
calculated and plotted (an unnecessary plot if, say, linear emulators have been trained).
The remaining options control visual aspects of the plots: \code{line.plot} determines
whether a line or bar (default) plot should be produced, \code{grid.plot} determines
whether the results are plotted as a graph or a grid, and \code{labels} determines
if a legend should be provided with the plot (for large numbers of emulators, it is
advisable to set this to \code{FALSE}).
}
\examples{
 effect <- effect_strength(SIREmulators$ems)
 effect_line <- effect_strength(SIREmulators$ems, line.plot = TRUE)
 effect_grid <- effect_strength(SIREmulators$ems, grid.plot = TRUE)
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
