% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.hmclearn}
\alias{predict.hmclearn}
\title{Model Predictions for HMC or MH}
\usage{
\method{predict}{hmclearn}(object, X, fam = "linear", burnin = NULL, draws = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{X}{design matrix, either from fitting the model or new data}

\item{fam}{generalized linear model family.  Currently "linear", "binomial", and "poisson" are supported}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{draws}{Number of simulated values from the posterior conditioned on \code{X}}

\item{...}{additional parameters, currently unsupported}
}
\value{
An object of class \code{hmclearnpred}.
}
\description{
\code{predict} generates simulated data from the posterior predictive distribution.
This simulated data can be used for posterior predictive check diagnostics from the \code{bayesplot} package
}
\section{Elements of \code{hmclearnpred} objects}{

\describe{
  \item{\code{y}}{
  Median simulated values for each observation in \code{X}
  }
  \item{\code{yrep}}{
  Matrix of simulated values where each row is a draw from the posterior predictive distribution
  }
  \item{\code{X}}{
  Numeric design matrix
  }
}
}

\examples{
# Linear regression example
set.seed(521)
X <- cbind(1, matrix(rnorm(300), ncol=3))
betavals <- c(0.5, -1, 2, -3)
y <- X\%*\%betavals + rnorm(100, sd=.2)

f1 <- hmc(N = 500,
          theta.init = c(rep(0, 4), 1),
          epsilon = 0.01,
          L = 10,
          logPOSTERIOR = linear_posterior,
          glogPOSTERIOR = g_linear_posterior,
          varnames = c(paste0("beta", 0:3), "log_sigma_sq"),
          param=list(y=y, X=X), parallel=FALSE, chains=1)

summary(f1)

p <- predict(f1, X)
predvals <- p$y
plot(predvals, y, xlab="predicted", ylab="actual")

X2 <- cbind(1, matrix(rnorm(30), ncol=3))
p2 <- predict(f1, X2)
p2$y

}
\references{
Gabry, Jonah and Mahr, Tristan (2019).  \emph{bayesplot:  Plotting for Bayesian Models}.  \url{https://mc-stan.org/bayesplot}

Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman, A (2019).  \emph{Visualization in Bayesian Workflow}.  Journal of the Royal Statistical Society: Series A. Vol 182.  Issue 2.  p.389-402.
}
