% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_diag.R
\name{neff.hmclearn}
\alias{neff.hmclearn}
\title{Effective sample size calculation}
\usage{
\method{neff}{hmclearn}(object, burnin = NULL, lagmax = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{lagmax}{maximum lag to extract for determining effective sample sizes}

\item{...}{currently unused}
}
\value{
Numeric vector with effective sample sizes for each parameter in the model
}
\description{
Calculates an estimate of the adjusted MCMC sample size per parameter
adjusted for autocorrelation.
}
\examples{
# poisson regression example
set.seed(7363)
X <- cbind(1, matrix(rnorm(40), ncol=2))
betavals <- c(0.8, -0.5, 1.1)
lmu <- X \%*\% betavals
y <- sapply(exp(lmu), FUN = rpois, n=1)

f <- hmc(N = 1000,
          theta.init = rep(0, 3),
          epsilon = c(0.03, 0.02, 0.015),
          L = 10,
          logPOSTERIOR = poisson_posterior,
          glogPOSTERIOR = g_poisson_posterior,
          varnames = paste0("beta", 0:2),
          param = list(y=y, X=X),
          parallel=FALSE, chains=2)

neff(f, burnin=100)
}
\references{
Gelman, A., et. al. (2013) \emph{Bayesian Data Analysis}.  Chapman and Hall/CRC.  Section 11.5
}
