% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_plot_tau.R
\name{hb_plot_tau}
\alias{hb_plot_tau}
\title{Plot tau}
\usage{
hb_plot_tau(mcmc)
}
\arguments{
\item{mcmc}{Data frame of posterior samples generated by
\code{\link[=hb_mcmc_hierarchical]{hb_mcmc_hierarchical()}}.}
}
\value{
A \code{ggplot} object
}
\description{
Plot the tau parameter of a fitted hierarchical model.
}
\examples{
data <- hb_sim_independent(n_continuous = 2)$data
mcmc <- hb_mcmc_hierarchical(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 100,
  n_iterations = 200
)
hb_plot_tau(mcmc = mcmc)
}
\seealso{
Other plot: 
\code{\link{hb_plot_borrow}()},
\code{\link{hb_plot_group}()}
}
\concept{plot}
