% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readh_yield.R, R/yields.R
\name{hipread_long_yield}
\alias{hipread_long_yield}
\alias{hipread_list_yield}
\alias{HipYield}
\alias{HipLongYield}
\alias{HipListYield}
\title{Read a hierarchical fixed width data file, in yields}
\usage{
hipread_long_yield(
  file,
  var_info,
  rt_info = hip_rt(1, 0),
  compression = NULL,
  skip = 0,
  encoding = "UTF-8"
)

hipread_list_yield(
  file,
  var_info,
  rt_info = hip_rt(1, 0),
  compression = NULL,
  skip = 0,
  encoding = "UTF-8"
)
}
\arguments{
\item{file}{A filename}

\item{var_info}{Variable information, specified by either \code{\link[=hip_fwf_positions]{hip_fwf_positions()}}
or \code{hip_fwf_widths()}. For hierarchical data files, there should be a named list,
where the name is the value indicated by the record type variable and there is
one variable information per record type.}

\item{rt_info}{A record type information object, created by \code{\link[=hip_rt]{hip_rt()}}, which
contains information about the location of the record type variable that
defines the record type for each observation. The default contains width
0, which indicates that there the data is rectangular and does not have
a record type variable.}

\item{compression}{If \code{NULL}, guesses the compression from the
file extension (if extension is "gz" uses gzip, otherwise
treats as plain text), can specify it with a string ("txt"
indicates plain text and "gz" for gzip).}

\item{skip}{Number of lines to skip at the start of the data (defaults to 0).}

\item{encoding}{(Defaults to UTF-8) A string indicating what encoding to use
when reading the data, but like readr, the data will always be converted to
UTF-8 once it is imported. Note that UTF-16 and UTF-32 are not supported for
non-character columns.}
}
\value{
A HipYield R6 object (See 'Details' for more information)
}
\description{
Enhances \code{hipread_long()} or \code{hipread_list()} to allow you to read
hierarchical data in pieces (called 'yields') and allow your code to
have full control between reading pieces, allowing for more freedom
than the 'callback' method introduced in the chunk functions (like
\code{\link[=hipread_long_chunked]{hipread_long_chunked()}}).
}
\details{
These functions return a HipYield R6 object which have the following
methods:
\itemize{
\item \code{yield(n = 10000)} A function to read the next 'yield' from the data,
returns a \code{tbl_df} (or list of \code{tbl_df} for \code{hipread_list_yield()})
with up to n rows (it will return NULL if no rows are left, or all
available ones if less than n are available).
\item \code{reset()} A function to reset the data so that the next yield will
read data from the start.
\item \code{is_done()} A function that returns whether the file has been completely
read yet or not.
\item \code{cur_pos} A property that contains the next row number that will be
read (1-indexed).
}
}
\examples{
library(hipread)
data <- hipread_long_yield(
  hipread_example("test-basic.dat"),
  list(
    H = hip_fwf_positions(
      c(1, 2, 5, 8),
      c(1, 4, 7, 10),
      c("rt", "hhnum", "hh_char", "hh_dbl"),
      c("c", "i", "c", "d")
    ),
    P = hip_fwf_widths(
      c(1, 3, 1, 3, 1),
      c("rt", "hhnum",  "pernum", "per_dbl", "per_mix"),
      c("c", "i", "i", "d", "c")
    )
  ),
  hip_rt(1, 1)
)
# Read the first 4 rows
data$yield(4)

# Read the next 2 rows
data$yield(2)

# Reset and then read the first 4 rows again
data$reset()
data$yield(4)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HipYield-new}{\code{HipYield$new()}}
\item \href{#method-HipYield-yield}{\code{HipYield$yield()}}
\item \href{#method-HipYield-reset}{\code{HipYield$reset()}}
\item \href{#method-HipYield-is_done}{\code{HipYield$is_done()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipYield-new"></a>}}
\if{latex}{\out{\hypertarget{method-HipYield-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipYield$new(
  file,
  var_info,
  rt_info = hip_rt(0, 1),
  compression = NULL,
  skip = 0,
  encoding = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipYield-yield"></a>}}
\if{latex}{\out{\hypertarget{method-HipYield-yield}{}}}
\subsection{Method \code{yield()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipYield$yield(n = 10000)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipYield-reset"></a>}}
\if{latex}{\out{\hypertarget{method-HipYield-reset}{}}}
\subsection{Method \code{reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipYield$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipYield-is_done"></a>}}
\if{latex}{\out{\hypertarget{method-HipYield-is_done}{}}}
\subsection{Method \code{is_done()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipYield$is_done()}\if{html}{\out{</div>}}
}

}
}
\section{Super class}{
\code{\link[hipread:HipYield]{hipread::HipYield}} -> \code{HipLongYield}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HipLongYield-new}{\code{HipLongYield$new()}}
\item \href{#method-HipLongYield-yield}{\code{HipLongYield$yield()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="HipYield" data-id="is_done"><a href='../../hipread/html/HipYield.html#method-HipYield-is_done'><code>hipread::HipYield$is_done()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="HipYield" data-id="reset"><a href='../../hipread/html/HipYield.html#method-HipYield-reset'><code>hipread::HipYield$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipLongYield-new"></a>}}
\if{latex}{\out{\hypertarget{method-HipLongYield-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipLongYield$new(
  file,
  var_info,
  rt_info = hip_rt(0, 1),
  compression = NULL,
  skip = 0,
  encoding = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipLongYield-yield"></a>}}
\if{latex}{\out{\hypertarget{method-HipLongYield-yield}{}}}
\subsection{Method \code{yield()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipLongYield$yield(n = 10000)}\if{html}{\out{</div>}}
}

}
}
\section{Super class}{
\code{\link[hipread:HipYield]{hipread::HipYield}} -> \code{HipListYield}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HipListYield-new}{\code{HipListYield$new()}}
\item \href{#method-HipListYield-yield}{\code{HipListYield$yield()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="HipYield" data-id="is_done"><a href='../../hipread/html/HipYield.html#method-HipYield-is_done'><code>hipread::HipYield$is_done()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="HipYield" data-id="reset"><a href='../../hipread/html/HipYield.html#method-HipYield-reset'><code>hipread::HipYield$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipListYield-new"></a>}}
\if{latex}{\out{\hypertarget{method-HipListYield-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListYield$new(
  file,
  var_info,
  rt_info = hip_rt(0, 1),
  compression = NULL,
  skip = 0,
  encoding = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HipListYield-yield"></a>}}
\if{latex}{\out{\hypertarget{method-HipListYield-yield}{}}}
\subsection{Method \code{yield()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListYield$yield(n = 10000)}\if{html}{\out{</div>}}
}

}
}
