% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth_filt.R
\name{depth_filt}
\alias{depth_filt}
\title{Sequencing depth filtering}
\usage{
depth_filt(countable, threshold)
}
\arguments{
\item{countable}{An OTU table (matrix/data.frame) indicating the absolute OTU abundances of multiple samples. Columns must refer to samples and rows to OTUs.}

\item{threshold}{A number indicating the minimum sequencing depth required to keep the sample.}
}
\description{
Filter samples based on a minimum sequencing depth.
}
\details{
Sequencing depth filtering
}
\examples{
data(bat.diet.otutable)
depth_filt(bat.diet.otutable,5000)
depth_filt(bat.diet.otutable,threshold=20000)
}
\references{
Alberdi A, Aizpurua O, Bohmann K, Gopalakrishnan S, Lynggaard C, Nielsen M, Gilbert MTP. 2019. Promises and pitfalls of using high-throughput sequencing for diet analysis. Molecular Ecology Resources, 19(2), 327-348.\cr\cr
}
\seealso{
\code{\link{depth_cov}}, \code{\link{copy_filt}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{coverage}
\keyword{sequencing}
