% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_func.R
\name{hill_func}
\alias{hill_func}
\title{Functional diversity through Hill Numbers}
\usage{
hill_func(
  comm,
  traits,
  traits_as_is = FALSE,
  q = 0,
  base = exp(1),
  check_data = TRUE,
  div_by_sp = FALSE,
  ord = c("podani", "metric"),
  fdis = TRUE,
  stand_dij = FALSE
)
}
\arguments{
\item{comm}{A data frame of vegetation data. Sites as rows, species as columns.}

\item{traits}{A data frame of species functional traits data. Species as rows, traits as columns.
It can include both continuous and categorical data. It will be transformed into a distance
matrix using `FD::gowdis(traits)`. If all traits are numeric, then it will use Euclidean distance.}

\item{traits_as_is}{if \code{FALSE} (default) traits data frame will be transformed into a distance
matrix. Otherwise, will use as is (i.e. traits is a symmetric distance matrix).}

\item{q}{Hill number, \code{q} = 0 (default) to get species richness,
\code{q} = 1 to get shannon entropy, \code{q} = 2 will give inverse Simpson.}

\item{base}{default is \code{exp(1)}, the base of log.}

\item{check_data}{whether to check data first? Default is \code{TRUE}.}

\item{div_by_sp}{as FD calculated in this way will be highly correlated with taxonomic diversity,
one potential simple way to correct this is to divide the results by the number of species.
However, a more common way to deal with correlations is to use null models and calculate standardized effect sizes.
Therefore, I set the default to be \code{FALSE}.}

\item{ord}{ord in \code{FD::gowdis}.}

\item{fdis}{whether to calculated FDis, default is \code{TRUE}}

\item{stand_dij}{whether to standardize distance matrix to have max value of 1? Default is \code{FALSE}.}
}
\value{
A matrix, with these information for each site: Q (Rao's Q); D_q (functional hill number,
 the effective number of equally abundant and functionally equally distinct species);
 MD_q (mean functional diversity per species, the effective sum of pairwise distances between
 a fixed species and all other species); FD_q (total functional diversity, the effective total functional
 distance between species of the assemblage). See Chiu and Chao 2014 page 4 for more information.
}
\description{
Calculate functional diversity for each site (alpha diversity).
}
\examples{
dummy = FD::dummy
hill_func(comm = dummy$abun, traits = dummy$trait, q = 0)
hill_func(comm = dummy$abun, traits = dummy$trait, q = 1)
hill_func(comm = dummy$abun, traits = dummy$trait, q = 0.9999)
hill_func(comm = dummy$abun, traits = dummy$trait, q = 2)
hill_func(comm = dummy$abun, traits = dummy$trait, q = 3)

}
\references{
Chao, Anne, Chun-Huo Chiu, and Lou Jost. Unifying Species Diversity, Phylogenetic Diversity, Functional Diversity, and Related Similarity and Differentiation Measures Through Hill Numbers. Annual Review of Ecology, Evolution, and Systematics 45, no. 1 (2014): 297–324. <doi:10.1146/annurev-ecolsys-120213-091540>.

Chiu, Chun-Huo, and Anne Chao. Distance-Based Functional Diversity Measures and Their Decomposition: A Framework Based on Hill Numbers. PLoS ONE 9, no. 7 (July 7, 2014): e100014. <doi:10.1371/journal.pone.0100014>.
}
