% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dethrz.R
\name{check_det_hrz_input}
\alias{check_det_hrz_input}
\title{Checks the arguments of det_hrz}
\usage{
check_det_hrz_input(
  ppdata,
  type,
  criterion,
  cutoff,
  distancemap,
  intens,
  nxprob,
  covmatrix
)
}
\arguments{
\item{ppdata}{Observed spatial point process of class ppp.}

\item{type}{Method to use, can be one of \code{"dist"} (method of fixed radius or quantile-based method), or
\code{"intens"} (intensity-based method)}

\item{criterion}{criterion to limit the high-risk zone, can be one of 
\code{"area"} (giving size of hrz), \code{"indirect"} (giving quantile/alpha depending on type),
or \code{"direct"} (giving radius/threshold c depending on type)}

\item{cutoff}{Value of criterion (area, radius, quantile, alpha or threshold). 
Depending on criterion and type: 
If criterion = "direct" and type = "intens", cutoff is the maximum intensity of unexploded bombs
outside the risk zone. If type = "dist" instead, cutoff is the radius of the circle around each exploded bomb.
"If criterion = "indirect", cutoff is the quantile for the quantile-based method and the failure 
probability alpha for the intensity-base method. If criterion = "area", cutoff is the area the high-risk zone should
have.}

\item{distancemap}{(optional) distance map: distance of every pixel to the nearest observation 
of the point pattern; only needed for \code{type="dist"}. If not given, 
it will be computed by \code{\link[spatstat.geom]{distmap}}.}

\item{intens}{(optional) estimated intensity of the observed process (object of class "im"), 
only needed for type="intens". If not given,
it will be estimated using \code{\link[spatstat.core]{density.ppp}}.}

\item{nxprob}{Probability of having unobserved events.
Default value is 0.1.}

\item{covmatrix}{(optional) Covariance matrix of the kernel of a normal distribution, only needed for 
\code{type="intens"} if no intensity is given. If not given, it will be estimated
using \code{\link[ks]{Hscv}}.}
}
\description{
For each argument it is checked if it is of a correct value or class.
}
\seealso{
\code{\link{det_hrz}}
}
