% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{aggregatePrice}
\alias{aggregatePrice}
\title{Aggregate a time series but keep first and last observation}
\usage{
aggregatePrice(
  pData,
  alignBy = "minutes",
  alignPeriod = 1,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  fill = FALSE,
  tz = NULL
)
}
\arguments{
\item{pData}{\code{data.table} or \code{xts} object to be aggregated containing the intraday price series, possibly across multiple days.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. Possible values are: "secs", "seconds", "mins", "minutes","hours", and "ticks".
To aggregate based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. E.g. to aggregate
based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{marketOpen}{the market opening time, by default: \code{marketOpen = "09:30:00"}.}

\item{marketClose}{the market closing time, by default: \code{marketClose = "16:00:00"}.}

\item{fill}{indicates whether rows without trades should be added with the most recent value, FALSE by default.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. We attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}}
}
\value{
A \code{data.table} or \code{xts} object containing the aggregated time series.
}
\description{
Function to aggregate high frequency data by last tick aggregation to an arbitrary periodicity based on wall clocks.
Alternatively the aggregation can be done by number of ticks. In case we DON'T do tick-based aggregation, 
this function accepts arbitrary number of symbols over a arbitrary number of days. Although the function has the word Price in the name,
the function is general and works on arbitrary time series, either \code{xts} or \code{data.table} objects the latter requires a \code{DT}
column containing POSIXct time stamps.
}
\details{
The time stamps of the new time series are the closing times and/or days of the intervals. 
The element of the returned series with e.g. time stamp 09:35:00 contains
the last observation up to that point, including the value at 09:35:00 itself.

In case \code{alignBy = "ticks"}, the sampling is done such the sampling starts on the first tick, and the last tick is always included.
For example, if 14 observations are made on one day, and these are 1, 2, 3, ... 14.
Then, with \code{alignBy = "ticks"} and \code{alignPeriod = 3}, the output will be 1, 4, 7, 10, 13, 14.
}
\examples{
\dontshow{if (!grepl("debian", sessionInfo()["platform"], fixed = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Aggregate price data to the 30-second frequency
aggregatePrice(sampleTData, alignBy = "secs", alignPeriod = 30)

# Aggregate price data to 30-minute frequency including zero return price changes
aggregatePrice(sampleTData, alignBy = "minutes", alignPeriod = 30, fill = TRUE)
\dontshow{\}) # examplesIf}
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{data}
\keyword{manipulation}
