% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rBPCov}
\alias{rBPCov}
\title{Realized BiPower Covariance}
\usage{
rBPCov(
  rData,
  cor = FALSE,
  alignBy = NULL,
  alignPeriod = NULL,
  makeReturns = FALSE,
  makePsd = FALSE
)
}
\arguments{
\item{rData}{a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}

\item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{alignBy}{a string, align the tick data to "seconds"|"minutes"|"hours".}

\item{alignPeriod}{an integer, align the tick data to this many [seconds|minutes|hours].}

\item{makeReturns}{boolean, should be TRUE when rData contains prices instead of returns. FALSE by default.}

\item{makePsd}{boolean, in case it is TRUE, the positive definite version of rBPCov is returned. FALSE by default.}
}
\value{
an \eqn{N x N} matrix or a list of matrices if the time period spans multiple days
}
\description{
Function returns the Realized BiPower Covariance (rBPCov), 
 defined in Barndorff-Nielsen and Shephard (2004).
 
 Let \eqn{r_{t,i}} be an intraday \eqn{N x 1} return vector and \eqn{i=1,...,M} 
 the number of intraday returns.
 
 The rBPCov is defined as the process whose value at time \eqn{t}
 is the \eqn{N}-dimensional square matrix with \eqn{k,q}-th element equal to
 \deqn{
   \mbox{rBPCov}[k,q]_t = \frac{\pi}{8} \bigg( \sum_{i=2}^{M} 
                                              \left|
                                                r_{(k)t,i} + r_{(q)t,i} \right| \ \left| r_{(k)t,i-1} + r_{(q)t,i-1} \right|   \\
                                              - \left| r_{(k)t,i}  - r_{(q)t,i} \right| \ \left|
                                                r_{(k)t,i-1} - r_{(q)t,i-1} \right|  \bigg),
 }
 where \eqn{r_{(k)t,i}} is the
 \eqn{k}-th component of the return vector \eqn{r_{i,t}}.
}
\examples{
# Realized Bipower Variance/Covariance for a price series aligned   
# at 5 minutes.
 
# Univariate: 
rbpv <- rBPCov(rData = sampleTData$PRICE, alignBy ="minutes", 
               alignPeriod = 5, makeReturns = TRUE) 
rbpv 
 
# Multivariate: 
rbpc <- rBPCov(rData = sample5MinPricesJumps['2010-01-04'], makeReturns = TRUE, makePsd = TRUE)
rbpc
 
}
\references{
Barndorff-Nielsen, O. and N. Shephard (2004). Measuring the impact of
jumps in multivariate price processes using bipower covariation. Discussion
paper, Nuffield College, Oxford University.
}
\author{
Jonathan Cornelissen and Kris Boudt
}
\keyword{volatility}
