% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{hc_legend}
\alias{hc_legend}
\title{Setting legend options to highchart objects}
\usage{
hc_legend(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments are defined in \url{http://api.highcharts.com/highcharts#legend}.}
}
\description{
Function to modify styles for the box containing the symbol, name and color for
each item or point item in the chart.
}
\examples{

data(citytemp)

highchart() \%>\% 
  hc_xAxis(categories = citytemp$month) \%>\% 
  hc_add_series(name = "Tokyo", data = citytemp$tokyo) \%>\% 
  hc_add_series(name = "London", data = citytemp$london) \%>\%
  hc_legend(align = "left", verticalAlign = "top",
            layout = "vertical", x = 0, y = 100) 
            
}
