% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hierband.path.R
\name{hierband.path}
\alias{hierband.path}
\title{Solves main optimization problem over a grid of lambda values}
\usage{
hierband.path(Sighat, nlam = 20, flmin = 0.01, lamlist = NULL, w = NULL,
  delta = NULL, maxiter = 100, tol = 1e-07)
}
\arguments{
\item{Sighat}{The sample covariance matrix}

\item{nlam}{Number of lambda values to include in grid.}

\item{flmin}{Ratio between the smallest lambda and largest lambda in grid. (Default: 0.01)
Decreasing this gives less sparse solutions.}

\item{lamlist}{A grid of lambda values to use.  If this is non-NULL, then \code{nlam} and \code{flmin} are ignored.}

\item{w}{\code{(p-1)}-by-\code{(p-1)} lower-triangular matrix (above diagonal ignored).
\code{w[l,]} gives the \code{l} weights for g_l.
Defaults to \code{w[l,m]=sqrt(2 * l)/(l - m + 1)} for \code{m <= l}}

\item{delta}{Lower bound on eigenvalues.  If this is NULL (which is default), then no eigenvalue
constraint is included.}

\item{maxiter}{Number of iterations of blockwise coordinate descent to perform.}

\item{tol}{Only used when \code{delta} is non-NULL.  When no eigenvalue changes by more than
\code{tol} in BCD, convergence is assumed.}
}
\value{
Returns a sequence of convex banded estimates of the covariance matrix.
\describe{
\item{P: }{A \code{nrow(Sighat)}-by-\code{nrow(Sighat)}-by-\code{nlam} array where \code{P[, , i]} gives the \code{i}th estimate of the covariance matrix.}
\item{lamlist: }{Grid of lambda values used.}
\item{w: }{Value of w used.}
\item{delta: }{Value of delta used.}
}
}
\description{
See \code{\link{hierband}} for the problem this is solving.  If \code{lamlist} not provided, then grid will be constructed
starting at lambda_max, the smallest value of lam for which the solution (with \code{delta=NULL}) is diagonal.
}
\examples{
set.seed(123)
p <- 100
n <- 50
K <- 10
true <- ma(p, K)
x <- matrix(rnorm(n*p), n, p) \%*\% true$A
Sighat <- cov(x)
path <- hierband.path(Sighat)
cv <- hierband.cv(path, x)
fit <- hierband(Sighat, lam=cv$lam.best)
}
\seealso{
\code{\link{hierband}} \code{\link{hierband.cv}}
}

