% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ihs4_char.R
\name{ihs4_char}
\alias{ihs4_char}
\title{Converts IHS4 numerical scores to character values.}
\usage{
ihs4_char(ihs4_scores)
}
\arguments{
\item{ihs4_scores}{Integer vector representing the IHS4 scores (0-3: Mild,
4-10: Moderate, >=11: Severe).}
}
\value{
A character vector representing the corresponding IHS4 categories
}
\description{
Converts IHS4 numerical scores to character values.
}
\examples{
ihs4_char(c(2, 5, 12))
}
\references{
Zouboulis, C C et al. “Development and validation of the
International Hidradenitis Suppurativa Severity Score System (IHS4),
a novel dynamic scoring system to assess HS severity.” The British
journal of dermatology vol. 177,5 (2017): 1401-1409. doi:10.1111/bjd.15748
}
\seealso{
Other IHS4: 
\code{\link{ihs4_num}()}
}
\concept{IHS4}
