% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixlm.R
\name{rmixlm}
\alias{rmixlm}
\title{Random data generation from the mixture of Gaussian linear (Markov-switching) models for hhsmm model}
\usage{
rmixlm(j, model, covar.mean, covar.cov)
}
\arguments{
\item{j}{a specified state}

\item{model}{a \code{\link{hhsmmspec}} model}

\item{covar.mean}{the mean vector of covariates (to be generated from multivariate normal distribution)}

\item{covar.cov}{the variance-covariance matrix of covariates (to be generated from multivariate normal distribution)}
}
\value{
a random matrix of observations from mixture of Gaussian linear (Markov-switching) models,
in which the first columns are associated with the responses
and the last columns are associated with the covariates
}
\description{
Generates vectors of covariate and response observations
from mixture of Gaussian linear (Markov-switching) models in a specified state and using the
parameters of a specified model
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- rep(FALSE, 3)
P <- matrix(c(0.5, 0.2, 0.3, 0.2, 0.5, 0.3, 0.1, 0.4, 0.5), nrow = J, 
byrow = TRUE)
par <- list(intercept = list(3, list(-10, -1), 14),
coefficient = list(-1, list(1, 5), -7),
csigma = list(1.2, list(2.3, 3.4), 1.1),
mix.p = list(1, c(0.4, 0.6), 1))
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixlm, semi = semi)
train <- simulate(model, nsim = c(20, 30, 42, 50), seed = 1234, 
remission = rmixlm, covar.mean = 0, covar.cov = 1)
plot(train$x[,1] ~ train$x[,2], col = train$s, pch = 16, 
xlab = "x", ylab = "y")

}
\references{
Kim, C. J., Piger, J. and Startz, R. (2008). Estimation of Markov
regime-switching regression models with endogenous switching.
Journal of Econometrics, 143(2), 263-273.
}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
