% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.hfr.R
\name{predict.hfr}
\alias{predict.hfr}
\title{Model predictions}
\usage{
\method{predict}{hfr}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Fitted 'hfr' model.}

\item{newdata}{Matrix or data.frame of new values for \code{x} at which predictions are to be made.}

\item{...}{additional methods passed to \code{predict}.}
}
\value{
A vector of predicted values.
}
\description{
Predict values using a fitted \code{hfr} model
}
\details{
Predictions are made by multiplying the \code{newdata} object with the estimated coefficients.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = hfr(x, y, kappa = 0.5)
predict(fit)

}
\seealso{
\code{\link{hfr}}, \code{\link{cv.hfr}} and \code{\link{coef}} methods
}
\author{
Johann Pfitzinger
}
