% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cv.hfr.R
\name{print.cv.hfr}
\alias{print.cv.hfr}
\title{Print an HFR model}
\usage{
\method{print}{cv.hfr}(x, ...)
}
\arguments{
\item{x}{Fitted \code{cv.hfr} model.}

\item{...}{additional methods passed to \code{print}.}
}
\value{
Summary statistics of HFR model
}
\description{
Print summary statistics for a fitted \code{cv.hfr} model
}
\details{
The call that produced the object \code{x} is printed, following by a
\code{data.frame} of summary statistics, including the effective degrees of freedom
of the model, the R.squared and the regularization parameter.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = cv.hfr(x, y, kappa_grid = seq(0, 1, by = 0.1))
print(fit)

}
\seealso{
\code{\link{hfr}}, \code{\link{cv.hfr}} and \code{\link{coef}} methods
}
\author{
Johann Pfitzinger
}
