% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_lonlat_to_quad_ij}
\alias{hexify_lonlat_to_quad_ij}
\title{Convert longitude/latitude to Quad IJ coordinates}
\usage{
hexify_lonlat_to_quad_ij(lon, lat, resolution, aperture = 3L)
}
\arguments{
\item{lon}{Longitude in degrees (-180 to 180)}

\item{lat}{Latitude in degrees (-90 to 90)}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
List with components:
\item{quad}{Quad number (0-11)}
\item{i}{Integer cell index along first axis}
\item{j}{Integer cell index along second axis}
\item{icosa_triangle_face}{Source icosahedral face (0-19)}
\item{icosa_triangle_x}{X coordinate on triangle face}
\item{icosa_triangle_y}{Y coordinate on triangle face}
}
\description{
Converts geographic coordinates to the intermediate Quad IJ representation
used internally by ISEA DGGS. Returns the quad number (0-11) and integer
cell indices (i, j) within that quad.
}
\details{
The 20 icosahedral triangle faces are grouped into 12 quads:
\itemize{
\item Quad 0: North polar region
\item Quads 1-5: Upper hemisphere rhombi
\item Quads 6-10: Lower hemisphere rhombi
\item Quad 11: South polar region
}
}
\examples{
# Get Quad IJ coordinates for Paris
result <- hexify_lonlat_to_quad_ij(lon = 2.35, lat = 48.86,
                                    resolution = 10, aperture = 3)
print(result)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
