% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_cell_to_quad_ij}
\alias{hexify_cell_to_quad_ij}
\title{Convert Cell ID to Quad IJ coordinates}
\usage{
hexify_cell_to_quad_ij(cell_id, resolution, aperture = 3L)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs (1-based)}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Data frame with columns:
\item{quad}{Quad number (0-11)}
\item{i}{Integer cell index along first axis}
\item{j}{Integer cell index along second axis}
}
\description{
Converts DGGRID-compatible cell IDs to Quad IJ coordinates.
This is the inverse of hexify_quad_ij_to_cell().
}
\details{
Compatible with 'dggridR' dgSEQNUM_to_Q2DI().
}
\examples{
# Get Quad IJ coordinates for a cell
result <- hexify_cell_to_quad_ij(cell_id = 1000, resolution = 10, aperture = 3)
print(result)

# Round-trip test
cell_id <- hexify_quad_ij_to_cell(result$quad, result$i, result$j,
                                   resolution = 10, aperture = 3)
# Should equal original cell_id
}
\seealso{
\code{\link{hexify_quad_ij_to_cell}} for the forward operation,
\code{\link{hexify_cell_to_icosa_tri}} for conversion to triangle coords

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
