% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_quad_ij_to_cell}
\alias{hexify_quad_ij_to_cell}
\title{Convert Quad IJ coordinates to cell ID}
\usage{
hexify_quad_ij_to_cell(quad, i, j, resolution, aperture = 3L)
}
\arguments{
\item{quad}{Quad number (0-11), integer or vector}

\item{i}{Cell index along first axis, integer or vector}

\item{j}{Cell index along second axis, integer or vector}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Numeric vector of cell IDs
}
\description{
Converts Quad IJ coordinates to a global cell identifier.
This is the final step in the coordinate pipeline.
}
\examples{
# Convert Quad IJ to cell ID
cell_id <- hexify_quad_ij_to_cell(quad = 1, i = 100, j = 50,
                                   resolution = 10, aperture = 3)
print(cell_id)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
