% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.stateprobs}
\alias{autoplot.stateprobs}
\title{Plot state probabilities}
\usage{
\method{autoplot}{stateprobs}(
  object,
  labels = NULL,
  ci = FALSE,
  prob = 0.95,
  ci_style = c("ribbon", "line"),
  geom_alpha = 0.3,
  ...
)
}
\arguments{
\item{object}{A \code{\link{stateprobs}} object.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}

\item{ci}{A logical value indicating whether confidence intervals should be
plotted. Default is \code{FALSE}.}

\item{prob}{A numeric scalar in the interval \verb{(0,1)} giving the confidence interval.
Default is 0.95 for a 95 percent interval.}

\item{ci_style}{Style to use for the confidence interval if \code{ci = TRUE}. If
\code{"line"}, then dashed lines are used; if \code{"ribbon"}, then shaded confidence
bands are plotted using \code{ggplot2::geom_ribbon()}.}

\item{geom_alpha}{The opacity for the shaded confidence bands when
\code{ci_style = "ribbon"}. This is the value of the value of the \code{alpha} aesthetic
passed to \code{ggplot2::geom_ribbon()}.}

\item{...}{Further arguments passed to and from methods. Currently unused.}
}
\value{
A \code{ggplot} object.
}
\description{
Quickly plot state probabilities stored in a \code{\link{stateprobs}} object.
}
\note{
If there are multiple patients/groups, then state probabilities are
averaged across patients/groups (using the weights in \code{patient_wt} if available)
prior to plotting.
}
\seealso{
\code{\link{Psm}} for an example.
}
