% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{multinom3_exdata}
\alias{multinom3_exdata}
\title{Example data for a 3-state multinomial model}
\format{
A list containing the following elements:
\itemize{
\item{transitions}{ A data frame containing patient transitions between health
states at discrete time intervals (i.e., on a yearly basis).}
\item{costs}{ A list of data frames. The first data frame contains
drug cost data and the second contains summary medical cost estimates.}
\item{utility}{ A data frame of summary utility estimates.}
}
}
\usage{
multinom3_exdata
}
\description{
Example discrete time health state transitions data simulated using
multinomial logistic regression. Costs and utility
are also included to facilitate cost-effectiveness analysis.
}
\section{Transitions data}{

The data frame has the following columns:
\describe{
\item{patient_id}{Patient identification number.}
\item{strategy_id}{Treatment strategy identification number.}
\item{strategy_name}{Treatment strategy name.}
\item{age}{Patient age (in years).}
\item{age_cat}{A factor variable with 3 age groups: (i) age less than 40,
(ii) age at least 40 and less than 60, and (iii) age at least 60.}
\item{female}{1 if a patient is female; 0 if male.}
\item{year}{The year since the start of data collection with the first year equal to 1.}
\item{state_from}{State making a transition from.}
\item{state_to}{State making a transition to.}
\item{year_cat}{Factor variable for year with 3 categories: (i) year 3 and below, (ii)
year between 3 and 6, and (iii) year 7 and above.}
}
}

\section{Cost data}{

The cost list contains two data frames. The first data frame contains
data on the drug costs associated with each treatment strategy.
\describe{
\item{strategy_id}{The treatment strategy identification number.}
\item{strategy_name}{The treatment strategy name.}
\item{costs}{Annualized drug costs.}
}

The second data frame contains summary data on
medical costs by health state, and contains the following columns:
\describe{
\item{state_id}{The health state identification number.}
\item{state_name}{The name of the health state.}
\item{mean}{Mean medical costs.}
\item{se}{Standard error of medical costs.}
}
}

\section{Utility data}{

The data frame has the following columns:
\describe{
\item{state_id}{The health state identification number.}
\item{state_name}{The name of the health state.}
\item{mean}{Mean utility}
\item{se}{Standard error of utility.}
}
}

\keyword{datasets}
