% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_surv_list}
\alias{params_surv_list}
\title{Parameters of a list of survival models}
\usage{
params_surv_list(...)
}
\arguments{
\item{...}{Objects of class \code{\link{params_surv}}, which can be named.}
}
\value{
An object of class \code{params_surv_list}, which is a list containing \code{\link{params_surv}}
objects.
}
\description{
Create a list containing the parameters of multiple fitted parametric survival models.
}
\examples{
library("flexsurv")
fit_wei <- flexsurvreg(Surv(futime, fustat) ~ 1, data = ovarian, dist = "weibull")
params_wei <- create_params(fit_wei, n = 2)

fit_exp <- flexsurvreg(Surv(futime, fustat) ~ 1, data = ovarian, dist = "exp")
params_exp <- create_params(fit_exp, n = 2)

params_list <- params_surv_list(wei = params_wei, exp = params_exp)
print(params_list)
}
