% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psm.R
\name{PsmCurves}
\alias{PsmCurves}
\title{Partitioned survival curves}
\format{
An \link[R6:R6Class]{R6::R6Class} object.
}
\description{
Summarize \code{n-1} survival curves for an \code{N} state partitioned survival model.
}
\examples{
library("flexsurv")

# Simulation data
dt_strategies <- data.frame(strategy_id = c(1, 2, 3))
dt_patients <- data.frame(patient_id = seq(1, 3),
                          age = c(45, 50, 60),
                          female = c(0, 0, 1))
hesim_dat <- hesim_data(strategies = dt_strategies,
                        patients = dt_patients)

# Fit survival models
surv_est_data <- psm4_exdata$survival
fit1 <- flexsurv::flexsurvreg(Surv(endpoint1_time, endpoint1_status) ~ age,
                              data = surv_est_data, dist = "exp")
fit2 <- flexsurv::flexsurvreg(Surv(endpoint2_time, endpoint2_status) ~ age,
                              data = surv_est_data, dist = "exp")
fit3 <- flexsurv::flexsurvreg(Surv(endpoint3_time, endpoint3_status) ~ age,
                              data = surv_est_data, dist = "exp")
fits <- flexsurvreg_list(fit1, fit2, fit3)

# Form PsmCurves
surv_input_data <- expand(hesim_dat, by = c("strategies", "patients"))
psm_curves <- create_PsmCurves(fits, input_data = surv_input_data, n = 3,
                               bootstrap = TRUE, est_data = surv_est_data)

# Summarize survival curves
head(psm_curves$quantile(p = c(.25, .5, .75)))
head(psm_curves$survival(t = seq(0, 3, by = .1)))
head(psm_curves$rmst(t = c(2, 5)))

}
\seealso{
\link{Psm}, \code{\link[=create_PsmCurves]{create_PsmCurves()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{params}}{An object of class \link{params_surv_list}.}

\item{\code{input_data}}{An object of class \link{input_mats}. Each row in \code{X} must
be a unique treatment strategy and patient.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PsmCurves$new()}}
\item \href{#method-hazard}{\code{PsmCurves$hazard()}}
\item \href{#method-cumhazard}{\code{PsmCurves$cumhazard()}}
\item \href{#method-survival}{\code{PsmCurves$survival()}}
\item \href{#method-rmst}{\code{PsmCurves$rmst()}}
\item \href{#method-quantile}{\code{PsmCurves$quantile()}}
\item \href{#method-check}{\code{PsmCurves$check()}}
\item \href{#method-clone}{\code{PsmCurves$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{PsmCurves} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$new(params, input_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{The \code{params} field.}

\item{\code{input_data}}{The \code{input_data} field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{PsmCurves} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hazard"></a>}}
\if{latex}{\out{\hypertarget{method-hazard}{}}}
\subsection{Method \code{hazard()}}{
Predict the hazard function for each survival curve as a function of time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$hazard(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{sample}, \code{strategy_id},
\code{patient_id}, \code{grp_id}, \code{curve} (the curve number), \code{t}, and \code{hazard}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cumhazard"></a>}}
\if{latex}{\out{\hypertarget{method-cumhazard}{}}}
\subsection{Method \code{cumhazard()}}{
Predict the cumulative hazard function for each survival curve as a function of time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$cumhazard(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{sample}, \code{strategy_id},
\code{patient_id}, \code{grp_id}, \code{curve}, \code{t}, and \code{cumhazard}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-survival"></a>}}
\if{latex}{\out{\hypertarget{method-survival}{}}}
\subsection{Method \code{survival()}}{
Predict the cumulative hazard function for each survival curve as a function of time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$survival(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{sample}, \code{strategy_id},
\code{patient_id}, \code{grp_id}, \code{curve}, \code{t}, and \code{survival}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rmst"></a>}}
\if{latex}{\out{\hypertarget{method-rmst}{}}}
\subsection{Method \code{rmst()}}{
Predict the restricted mean survival time up until time points \code{t}
for each survival curve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$rmst(t, dr = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}

\item{\code{dr}}{Discount rate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{sample}, \code{strategy_id},
\code{patient_id}, \code{grp_id}, \code{curve}, \code{t}, and \code{rmst}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Predict quantiles of the survival distribution for each survival curve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$quantile(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{A numeric vector of probabilities for computing quantiles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{sample}, \code{strategy_id},
\code{patient_id}, \code{grp_id}, \code{curve}, \code{p} and \code{quantile}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check"></a>}}
\if{latex}{\out{\hypertarget{method-check}{}}}
\subsection{Method \code{check()}}{
Input validation for class. Checks that fields are the correct type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$check()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PsmCurves$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
