% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-fits.R
\name{flexsurvreg_list}
\alias{flexsurvreg_list}
\title{List of \code{flexsurvreg} objects}
\usage{
flexsurvreg_list(...)
}
\arguments{
\item{...}{Objects of class \code{\link{flexsurvreg}}, which can be named.}
}
\value{
Returns an object of class "flexsurvreg_list".
}
\description{
Return an object of class "flexsurvreg_list" from multiple objects of class
\code{\link{flexsurvreg}}.
}
\examples{
 library("flexsurv")
 fit1 <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, data = ovarian, dist = "weibull")
 fit2 <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, data = ovarian, dist = "exp")
 fsreg_list <- flexsurvreg_list(wei = fit1, exp = fit2)
 class(fsreg_list)
}
