% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traffic.R
\name{traffic}
\alias{traffic}
\title{HERE Traffic API: Flow and Incidents}
\usage{
traffic(
  aoi,
  product = "flow",
  from = NULL,
  to = NULL,
  min_jam_factor = 0,
  url_only = FALSE
)
}
\arguments{
\item{aoi}{\code{sf} object, Areas of Interest (POIs) of geometry type \code{POLYGON}.}

\item{product}{character, traffic product of the 'Traffic API'. Supported products: \code{"flow"} and \code{"incidents"}.}

\item{from}{\code{POSIXct} object, datetime of the earliest traffic incidents (Note: Only takes effect if \code{product} is set to \code{"incidents"}).}

\item{to}{\code{POSIXct} object, datetime of the latest traffic incidents (Note: Only takes effect if \code{product} is set to \code{"incidents"}).}

\item{min_jam_factor}{numeric, only retrieve flow information with a jam factor greater than the value provided (Note: Only takes effect if \code{product} is set to \code{"flow"}, \code{default = 0}).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested traffic information.
}
\description{
Real-time traffic flow and incident information based on the HERE 'Traffic' API in areas of interest (AOIs).
The traffic flow data contains speed (\code{"SP"}) and congestion (jam factor: \code{"JF"}) information.
Traffic incidents contain information about location, time, duration, severity, description and other details.
}
\note{
Explanation of the returned traffic flow variables:
\itemize{
  \item\code{"PC"}: Point TMC location code.
  \item\code{"DE"}: Text description of the road.
  \item\code{"QD"}: Queuing direction. '+' or '-'. Note this is the opposite of the travel direction in the fully qualified ID, For example for location 107+03021 the QD would be ‚-‚.
  \item\code{"LE"}: Length of the stretch of road.
  \item\code{"TY"}: Type information for the given Location Referencing container. This may be a freely defined string.
  \item\code{"SP"}: Speed (based on UNITS) capped by speed limit.
  \item\code{"FF"}: The free flow speed on this stretch of the road.
  \item\code{"JF"}: The number between 0.0 and 10.0 indicating the expected quality of travel. When there is a road closure, the Jam Factor will be 10. As the number approaches 10.0 the quality of travel is getting worse. -1.0 indicates that a Jam Factor could not be calculated.
  \item\code{"CN"}: Confidence, an indication of how the speed was determined. -1.0 road closed. 1.0=100\%.
}
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Real-time traffic flow
flow <- traffic(
  aoi = aoi[aoi$code == "LI", ],
  product = "flow",
  url_only = TRUE
)

# All traffic incidents from 2018 till end of 2019
incidents <- traffic(
  aoi = aoi[aoi$code == "LI", ],
  product = "incidents",
  from = as.POSIXct("2018-01-01 00:00:00"),
  to = as.POSIXct("2019-12-31 23:59:59"),
  url_only = TRUE
)
}
\references{
\itemize{
  \item\href{https://developer.here.com/api-explorer/rest/traffic}{HERE Traffic API}
  \item\href{https://stackoverflow.com/questions/28476762/reading-traffic-flow-data-from-here-maps-rest-api}{Flow explanation, stackoverflow}
}
}
