% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{TIPI}
\alias{TIPI}
\title{Data on the Ten Item Personality Inventory}
\format{
A data frame with 1799 observations on the following 16 variables.
\describe{ 
  \item{\code{Extraversion}}{a numeric vector}
  \item{\code{Neuroticism}}{a numeric vector}
  \item{\code{Conscientiousness}}{a numeric vector}
  \item{\code{Agreeableness}}{a numeric vector} 
  \item{\code{Openness}}{a numeric vector} 
  \item{\code{education}}{an ordered factor with levels
      \code{<HS} < \code{HS} < \code{Univ} < \code{Grad}} 
  \item{\code{urban}}{an ordered factor with levels \code{Rural} < \code{Suburban} < \code{Urban}}
  \item{\code{gender}}{a factor with levels \code{M} \code{F}}
  \item{\code{engnat}}{a factor with levels \code{Native} \code{Non-native}}
  \item{\code{age}}{a numeric vector} 
  \item{\code{religion}}{a factor with levels \code{Agnostic} \code{Atheist} \code{Buddhist} \code{Christian
      (Catholic)} \code{Christian (Mormon)} \code{Christian (Protestant)}
      \code{Christian (Other)} \code{Hindu} \code{Jewish} \code{Muslim}
      \code{Sikh} \code{Other}} 
  \item{\code{orientation}}{a factor with levels \code{Heterosexual} \code{Bisexual} \code{Homosexual} 
      \code{Asexual} \code{Other}} 
  \item{\code{race}}{a factor with levels \code{Asian}
      \code{Arab} \code{Black} \code{Indig-White} \code{Other}}
  \item{\code{voted}}{a factor with levels \code{Yes} \code{No}}
  \item{\code{married}}{a factor with levels \code{Never married}
      \code{Currently married} \code{Previously married}}
  \item{\code{familysize}}{a numeric vector} 
}
}
\source{
Jones, P.J., Mair, P., Simon, T. et al. (2020). Network Trees: A
Method for Recursively Partitioning Covariance Structures.
\emph{Psychometrika}, \bold{85}, 926?945.
https://doi.org/10.1007/s11336-020-09731-4
}
\description{
The Ten Item Personality Inventory (Gosling et al. 2003) is a brief
inventory of the Big Five personality domains (Extraversion, Neuroticism,
Conscientiousness, Agreeableness, and Openness to experience). This dataset,
originally from the Open Source Psychometrics Project
(https://openpsychometrics.org/), was used by Jones et al. (2020), from
which we obtained this version.
}
\details{
In addition to scores on the Big Five scales, the dataset contains 11
demographic variables on the participants, potentially useful in
multivariate analyses.

Scores on each personality domain were calculated by averaging items
assigned to each domain (after reverse scoring specific items). In this
version, total scores for each scale were calculated by averaging the
positively and negatively coded items, for example, \code{TIPI$Extraversion
<- (TIPI$E + (8-TIPI$E_r))/2}.

Then, for the present purposes, some tidying was done: \itemize{ \item 100
cases with `gender=="Other" were deleted; \item codes for levels of
`education`, `engnat` and `race` were abbreviated for ease of use in
graphics. }
}
\examples{

data(TIPI)
# fit an mlm
tipi.mlm <- lm(cbind(Extraversion, Neuroticism, Conscientiousness, Agreeableness, Openness) 
               ~ engnat + gender + education, data = TIPI )
car::Anova(tipi.mlm)

heplot(tipi.mlm, fill=TRUE, fill.alpha=0.1)

pairs(tipi.mlm, fill=TRUE, fill.alpha=0.1)

# candisc works best for factors with >2 levels
library(candisc)
tipi.can <- candisc(tipi.mlm, term="education")
tipi.can

heplot(tipi.can, fill=TRUE, fill.alpha=0.1, 
       var.col = "darkred", var.cex = 1.5, var.lwd = 3)

}
\references{
Gosling, S. D., Rentfrow, P. J., & Swann, W. B, Jr. (2003). A
very brief measure of the Big-Five personality domains. \emph{Journal of
Research in Personality}, \bold{37}, 504?528.
}
\keyword{datasets}
