% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_eddm.R
\name{dfr_eddm}
\alias{dfr_eddm}
\title{Adapted Early Drift Detection Method (EDDM) method}
\usage{
dfr_eddm(
  min_instances = 30,
  min_num_errors = 30,
  warning_level = 0.95,
  out_control_level = 0.9
)
}
\arguments{
\item{min_instances}{The minimum number of instances before detecting change}

\item{min_num_errors}{The minimum number of errors before detecting change}

\item{warning_level}{Necessary level for warning zone}

\item{out_control_level}{Necessary level for a positive drift detection}
}
\value{
\code{dfr_eddm} object
}
\description{
EDDM (Early Drift Detection Method) aims to improve the detection rate of gradual concept drift in DDM, while keeping a good performance against abrupt concept drift. \url{doi:2747577a61c70bc3874380130615e15aff76339e}
}
\examples{
library(daltoolbox)
library(heimdall)

# This example assumes a model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4


model <- dfr_eddm()

detection <- c()
output <- list(obj=model, pred=FALSE)
for (i in 1:length(data$serie)){
 output <- update_state(output$obj, data$serie[i])
 if (output$pred){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, list(idx=i, event=output$pred, type=type))
}

detection <- as.data.frame(detection)
detection[detection$type == 'drift',]
}
