% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_ecdd.R
\name{dfr_ecdd}
\alias{dfr_ecdd}
\title{Adapted EWMA for Concept Drift Detection (ECDD) method}
\usage{
dfr_ecdd(lambda = 0.2, min_run_instances = 30, average_run_length = 100)
}
\arguments{
\item{lambda}{The minimum number of instances before detecting change}

\item{min_run_instances}{Necessary level for warning zone (2 standard deviation)}

\item{average_run_length}{Necessary level for a positive drift detection}
}
\value{
\code{dfr_ecdd} object
}
\description{
ECDD is a concept change detection method that uses an exponentially weighted moving average (EWMA) chart to monitor the misclassification rate of an streaming classifier.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example assumes a model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4


model <- dfr_ecdd()

detection <- c()
output <- list(obj=model, pred=FALSE)
for (i in 1:length(data$serie)){
 output <- update_state(output$obj, data$serie[i])
 if (output$pred){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, list(idx=i, event=output$pred, type=type))
}

detection <- as.data.frame(detection)
detection[detection$type == 'drift',]
}
