% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_define.R, R/matrix_plot.R
\name{define_transition}
\alias{define_transition}
\alias{define_transition_}
\alias{modify.uneval_matrix}
\alias{plot.uneval_matrix}
\title{Define Transition Matrix for Markov Model}
\usage{
define_transition(..., state_names)

define_transition_(.dots, state_names)

\method{modify}{uneval_matrix}(.OBJECT, ...)

\method{plot}{uneval_matrix}(x, relsize = 0.75, shadow.size = 0,
  latex = TRUE, ...)
}
\arguments{
\item{...}{Name-value pairs of expressions definig matrix
cells. Can refer to parameters defined with 
\code{\link{define_parameters}}. For \code{plot}, 
additional arguments passed to
\code{\link[diagram]{plotmat}}.}

\item{state_names}{character vector, optional. State 
names.}

\item{.dots}{Used to work around non-standard evaluation.}

\item{.OBJECT}{An object of class \code{uneval_matrix}.}

\item{x}{An \code{uneval_matrix} to plot.}

\item{relsize}{Argument passed to
\code{\link[diagram]{plotmat}}.}

\item{shadow.size}{Argument passed to 
\code{\link[diagram]{plotmat}}.}

\item{latex}{Argument passed to
\code{\link[diagram]{plotmat}}.}
}
\value{
An object of class \code{uneval_matrix} (actually
  a named list of \code{lazy} expressions).
}
\description{
Define a matrix of transition probabilities. Probability 
can depend on parameters defined with 
\code{\link{define_parameters}}, and can thus be 
time-dependent.
}
\details{
Parameters names are searched first in a parameter object
defined with \code{\link{define_parameters}} and linked 
with the matrix through \code{\link{define_strategy}}; 
then in the environment where the matrix was defined.

Matric cells are listed by row.

The completary probability of all other row probabilities
can be conveniently reffered as \code{C}.

Only matrix size is checked during this step (the matrix 
must be square). Other conditions (such as row sums being
equal to 1) are tested later, during model evaluation.

For the \code{modify} function existing matrix cells are 
replaced with the new expression. Cells are referenced by
name. Cell naming follows the \code{cell_x_y} convention,
with \code{x} being the row number and \code{y} the 
column number.
}
\examples{

# simple 3x3 transition matrix

mat_1 <- define_transition(
  .2, 0, .8,
  0, .1, .9,
  0, 0, 1
)
mat_1

plot(mat_1)

# referencing parameters
# rr must be present in a parameter object
# that must later be linked with define_strategy

define_transition(
  .5 - rr, rr,
  .4, .6
)

# can also use C

define_transition(
  C, rr,
  .4, .6
)

# updating cells from mat_1

modify(
  mat_1,
  cell_2_1 = .2,
  cell_2_3 = .7
)

# only matrix size is check, it is thus possible
# to define an incorrect matrix

# this matrix will generate an error later,
# during model evaluation

define_transition(
  .5, 3,
  -1, 2
)
}
