% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans-funcs.R
\name{kmeans_scree_data_tbl}
\alias{kmeans_scree_data_tbl}
\title{K-Means Scree Plot Data Table}
\usage{
kmeans_scree_data_tbl(.data)
}
\arguments{
\item{.data}{You must have a tibble in the working environment from the
\code{\link[=kmeans_mapped_tbl]{kmeans_mapped_tbl()}}}
}
\value{
A nested tibble
}
\description{
Take data from the \code{\link[=kmeans_mapped_tbl]{kmeans_mapped_tbl()}} and unnest it into a
tibble for inspection and for use in the \code{\link[=kmeans_scree_plt]{kmeans_scree_plt()}} function.
}
\details{
Takes in a single parameter of .data from \code{\link[=kmeans_mapped_tbl]{kmeans_mapped_tbl()}} and
transforms it into a tibble that is used for \code{\link[=kmeans_scree_plt]{kmeans_scree_plt()}}. It will
show the values (tot.withinss) at each center.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data\%>\%
   filter(ip_op_flag == "I") \%>\%
   filter(payer_grouping != "Medicare B") \%>\%
   filter(payer_grouping != "?") \%>\%
   select(service_line, payer_grouping) \%>\%
   mutate(record = 1) \%>\%
   as_tibble()

ui_tbl <-  kmeans_user_item_tbl(data_tbl, service_line, payer_grouping)

kmm_tbl <- kmeans_mapped_tbl(ui_tbl)

kmeans_scree_data_tbl(kmm_tbl)

}
\author{
Steven P. Sanderson II, MPH
}
