% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rii.R
\name{rii}
\alias{rii}
\title{Relative index of inequality (RII)}
\usage{
rii(
  est,
  subgroup_order,
  pop = NULL,
  scaleval = NULL,
  weight = NULL,
  psu = NULL,
  fpc = NULL,
  strata = NULL,
  conf.level = 0.95,
  linear = FALSE,
  force = FALSE,
  ...
)
}
\arguments{
\item{est}{The subgroup estimate.
Estimates must be available for all subgroups.}

\item{subgroup_order}{The order of subgroups in an increasing sequence.}

\item{pop}{The number of people within each subgroup.
Population size must be available for all subgroups.}

\item{scaleval}{The scale of the indicator. For example, the
scale of an indicator measured as a percentage is 100. The
scale of an indicator measured as a rate per 1000 population is 1000.}

\item{weight}{Individual sampling weight (required if data come from a
survey)}

\item{psu}{Primary sampling unit (required if data come from a survey)}

\item{fpc}{Finite population correction}

\item{strata}{Strata (required if data come from a survey)}

\item{conf.level}{confidence level of the interval.}

\item{linear}{TRUE/FALSE statement to specify the use of a linear
regression model for RII estimation (default is logistic regression)}

\item{force}{TRUE/FALSE statement to force calculation with missing
indicator estimate values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated RII value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The relative index of inequality (RII) is a relative measure of inequality
that represents the ratio of estimated indicator values between the
most-advantaged and most-disadvantaged, while taking into consideration the
situation in all other subgroups/individuals – using an appropriate
regression model. RII can be calculated using disaggregated data and
individual-level data. Subgroups in disaggregated data are weighted
according to their population share, while individuals are weighted by
sample weight in the case of data from surveys.
}
\details{
To calculate RII, a weighted sample of the whole population is ranked from
the most-disadvantaged subgroup (at rank 0) to the most-advantaged subgroup
(at rank 1). This ranking is weighted, accounting for the proportional
distribution of the population within each subgroup. The population of
each subgroup is then considered in terms of its range in the cumulative
population distribution, and the midpoint of this range. The indicator of
interest is then regressed against this midpoint value using an appropriate
regression model (e.g., a generalized linear model with logit link), and
the predicted values of the indicator are calculated for the two extremes
(rank 1 and rank 0). The ratio between the estimated values at rank 1
and rank 0 (covering the entire distribution) generates the RII value.
For more information on this inequality measure see Schlotheuber, A., &
Hosseinpoor, A. R. (2022) below.

\strong{Interpretation:} RII has the value of one if there is no inequality. RII
has only positive values. Greater absolute values indicate higher levels of
inequality. The further the value of RII from one, the higher the level of
inequality. For favourable indicators, values larger than one indicate a
concentration of the indicator among the advantaged and values smaller than
one indicate a concentration of the indicator among the disadvantaged. For
adverse indicators, values larger than one indicate a concentration of the
indicator among the disadvantaged and values smaller than one indicate a
concentration of the indicator among the advantaged. RII is a multiplicative
measure and has to be displayed on a logarithmic scale (values larger than
one are equivalent in magnitude to their reciprocal values smaller than one,
e.g., a value of 2 is equivalent in magnitude to a value of 0.5).

\strong{Type of summary measure:} Complex; relative; weighted

\strong{Applicability:} Ordered; more than two subgroups

\strong{Warning:} The confidence intervals are approximate
and might be biased.
}
\examples{
# example code
data(IndividualSample)
head(IndividualSample)
with(IndividualSample,
     rii(est = sba,
         subgroup_order = subgroup_order,
         weight = weight,
         psu = psu,
         strata = strata
         )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International journal of
environmental research and public health, 19 (6), 3697.
}
