% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingness.R
\name{summary.missingness}
\alias{summary.missingness}
\title{Summarizes data given by \code{\link{missingness}}}
\usage{
\method{summary}{missingness}(object, ...)
}
\arguments{
\item{object}{Data frame from \code{\link{missingness}}}

\item{...}{Unused}
}
\value{
a tibble of the top 5 missingness percentage levels with the count of
  the number of variables associated with each level. If no missingness is
  found, NULL is returned instead.
}
\description{
Interpreting \code{\link{missingness}} results from wide
  datasets is difficult. This function helps interpret missingness output by
  summarizing this output by listing: the percent of variables that
  contain missingness, the variable name of the variable with the maximum
  amount of missingness along with its percent of observations containing
  missing values, and a tibble that lists the top 5 missingness levels with
  the count of the number of variables associated with each level (0
  missingness level is ignored). If there are no variables with missingness,
  a message that reports no missingness is printed and NULL is returned
  instead.
}
\examples{
missingness(pima_diabetes) \%>\%
  summary()

}
