% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcai-impute.R
\name{hcai_impute}
\alias{hcai_impute}
\title{Specify imputation methods for an existing recipe}
\usage{
hcai_impute(recipe, nominal_method = "new_category",
  numeric_method = "mean", numeric_params = NULL, nominal_params = NULL)
}
\arguments{
\item{recipe}{A recipe object. imputation will be added to the sequence of
operations for this recipe.}

\item{nominal_method}{Defaults to \code{"new_category"}. Other choices are
\code{"bagimpute"} or \code{"knnimpute"}.}

\item{numeric_method}{Defaults to \code{"mean"}. Other choices are
\code{"bagimpute"} or \code{"knnimpute"}.}

\item{numeric_params}{A named list with parmeters to use with chosen
imputation method on numeric data. Options are \code{bag_model} (bagimpute
only), \code{bag_options} (bagimpute only), \code{knn_K}, (knnimpute only),
\code{impute_with}, (bag or knn) or \code{seed_val} (bag or knn).
See \link{step_bagimpute} or \link{step_knnimpute} for details.}

\item{nominal_params}{A named list with parmeters to use with chosen
imputation method on nominal data. Options are \code{bag_model} (bagimpute
only), \code{bag_options} (bagimpute only), \code{knn_K}, (knnimpute only),
\code{impute_with}, (bag or knn) or \code{seed_val} (bag or knn).
See \link{step_bagimpute} or \link{step_knnimpute} for details.}
}
\value{
An updated version of `recipe` with the new step
 added to the sequence of existing steps.
}
\description{
`hcai-impute` adds various imputation methods to an existing
recipe. Currently supports mean (numeric only), new_category (categorical
only), bagged trees, or knn.
}
\examples{
library(recipes)

n = 100
set.seed(9)
d <- tibble::tibble(patient_id = 1:n,
            age = sample(c(30:80, NA), size = n, replace = TRUE),
            hemoglobin_count = rnorm(n, mean = 15, sd = 1),
            hemoglobin_category = sample(c("Low", "Normal", "High", NA),
                                         size = n, replace = TRUE),
            disease = ifelse(hemoglobin_count < 15, "Yes", "No")
)

# Initialize
my_recipe <- recipe(disease ~ ., data = d)

# Create recipe
my_recipe <- my_recipe \%>\%
  hcai_impute()
my_recipe

# Train recipe
trained_recipe <- prep(my_recipe, training = d)

# Apply recipe
data_modified <- bake(trained_recipe, newdata = d)
missingness(data_modified)


# Specify methods:
my_recipe <- my_recipe \%>\%
  hcai_impute(numeric_method = "bagimpute",
    nominal_method = "new_category")
my_recipe

# Specify methods and params:
my_recipe <- my_recipe \%>\%
  hcai_impute(numeric_method = "knnimpute",
    numeric_params = list(knn_K = 4))
my_recipe
}
