% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bslmm.R
\name{mediate_bslmm}
\alias{mediate_bslmm}
\title{Bayesian Sparse Linear Mixed Model}
\usage{
mediate_bslmm(
  A,
  M,
  Y,
  C1 = NULL,
  C2 = C1,
  burnin = 30000,
  ndraws = 5000,
  ci_level = 0.95,
  weights = NULL,
  k = 2,
  lm0 = 1e-04,
  lm1 = 1,
  lma1 = 1,
  l = 1
)
}
\arguments{
\item{A}{length \code{n} numeric vector containing exposure variable}

\item{M}{\code{n x p} numeric matrix of high-dimensional mediators.}

\item{Y}{length \code{n} numeric vector containing continuous outcome variable.}

\item{C1}{optional numeric matrix of covariates to include in the outcome model.}

\item{C2}{optional numeric matrix of covariates to include in the mediator
model. Default is \code{C1}.}

\item{burnin}{number of MCMC draws prior to sampling.}

\item{ndraws}{number of MCMC draws after burn-in.}

\item{ci_level}{the desired credible interval level. Default is 0.95.}

\item{weights}{optional numeric vector of observation weights.}

\item{k}{shape parameter for the inverse gamma priors. Default is 2.}

\item{lm0}{scale parameter for the inverse gamma prior on the variance of the
smaller-variance normal components. Default is \code{1e-4}. If \code{k=2},
this parameter equals the prior mean on the smaller normal variance.}

\item{lm1}{scale parameter for the inverse gamma prior on the variance of the
larger-variance components of \code{beta_m}. Default is 1. If \code{k=2},
this parameter equals the prior mean on the larger normal variance of the
mediator-outcome associations.}

\item{lma1}{scale parameter for the inverse gamma prior on the variance of the
larger-variance components of \code{alpha_a}. Default is 1. If \code{k=2},
this parameter equals the prior mean on the larger normal variance of the
exposure-mediator associations.}

\item{l}{scale parameter for the other inverse gamma priors.}
}
\value{
A list containing:
\itemize{
\item \code{contributions}: a data frame containing the estimates, Bayesian credible
intervals, and posterior inclusion probabilities of the mediation contributions
\item \code{effects}: a data frame containing the estimated direct, global mediation,
and total effects.
}
}
\description{
\code{mediate_bslmm} fits the Bayesian sparse linear mixed model proposed by
Song et al. (2020) for high-dimensional mediation analysis, estimating the
mediation contributions of potential mediators.
}
\details{
\code{mediate_bslmm} is a wrapper function for the "BSLMM" option from \code{\link[bama:bama]{bama::bama()}},
which fits a Bayesian sparse linear mixed model for performing mediation
analysis with high-dimensional mediators. The model assumes that
the mediator-outcome associations (\eqn{\beta_m}) and the exposure-mediator
associations (\eqn{\alpha_a}) independently follow a mixture of small-variance
and high-variance normal distributions, and that if a mediator \eqn{M_j} has both
\eqn{(\beta_m)_j} and \eqn{(\alpha_a)_j} belonging to the larger-variance distribution,
it has a notably large mediation contribution compared to the others. The
posterior inclusion probability (PIP) of belonging to both larger-variance
distributions is reported for each mediator as \code{ab_pip}.
}
\examples{
A <- med_dat$A
M <- med_dat$M
Y <- med_dat$Y

# Toy example with small burnin and ndraws
out <- mediate_bslmm(A, M, Y, burnin = 100, ndraws = 10)
out$effects
head(out$contributions)


}
\references{
Song, Y. et al. Bayesian shrinkage estimation of high dimensional
causal mediation effects in omics studies. Biometrics 76, 700-710 (2020).
}
