% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5S.R
\docType{class}
\name{H5S-class}
\alias{H5S-class}
\alias{H5S}
\title{Class for representing HDF5 spaces}
\value{
Object of class \code{\link{H5S}}.
}
\description{
This class represents \code{Spaces} in HDF5. These are mostly useful to define the
dimensions of a dataset as well as the maximum dimensions to which it can grow. By default, the
maximum dimension is equal to the initial dimension. If you want the array to be able to grow arbitrarily
large in one dimension, set the maximum dimension for this index to \code{Inf}. See the examples below
for code how to do this.
}
\section{Methods}{

\describe{
\item{\code{new(type = c("simple", "scalar", "null"), dims = NULL,
  maxdims = dims, decode_buf = NULL, id = NULL)}}{

Create a new HDF5-space. This can be done by either specifying a space with appropriate dimensions or by
decoding a character string that represents an encoded space

\strong{Parameters}
\describe{
\item{type}{Either a \code{simple} space, for which \code{dims} and \code{maxdims} have to be given
or a \code{scalar} or \code{null} space. See the HDF5 user guide on spaces to explain the differences.}
\item{dims}{The dimension of the space in case it is of type \code{simple}}
\item{maxdims}{The maximal dimensions of the space}
\item{decode_buf}{The character string that holds the encoded representation of a space}
\item{id}{An existing HDF5 id; internal use only}
}}

\item{\code{copy()}}{

This function implements the HDF5-API function H5Scopy. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{encode()}}{

This function implements the HDF5-API function H5Sencode. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{is_simple()}}{

This function implements the HDF5-API function H5Sis_simple. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_simple_extent_ndims()}}{

This function implements the HDF5-API function H5Sget_simple_extent_ndims. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{offset_simple(offset)}}{

This function implements the HDF5-API function H5Soffset_simple. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_simple_extent_dims()}}{

This function implements the HDF5-API function H5Sget_simple_extent_dims. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_simple_extent_npoints()}}{

This function implements the HDF5-API function H5Sget_simple_extent_npoints. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_simple_extent_type()}}{

This function implements the HDF5-API function H5Sget_simple_extent_type. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{extent_copy(h5s_source)}}{

This function implements the HDF5-API function H5Sextent_copy. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{extent_equal(h5s_cmp)}}{

This function implements the HDF5-API function H5Sextent_equal. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{set_extent_simple(dims, maxdims)}}{

This function implements the HDF5-API function H5Sset_extent_simple. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{set_extent_none()}}{

This function implements the HDF5-API function H5Sset_extent_none. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_type()}}{

This function implements the HDF5-API function H5Sget_select_type. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_npoints()}}{

This function implements the HDF5-API function H5Sget_select_npoints. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_hyper_nblocks()}}{

This function implements the HDF5-API function H5Sget_select_hyper_nblocks. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_hyper_blocklist(startblock = 0,
  numblocks = (self$get_select_hyper_nblocks() - startblock))}}{

This function implements the HDF5-API function H5Sget_select_hyper_blocklist. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_elem_npoints()}}{

This function implements the HDF5-API function H5Sget_select_elem_npoints. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_elem_pointlist(startpoint = 0,
  numpoints = (self$get_select_elem_npoints() - startpoint))}}{

This function implements the HDF5-API function H5Sget_select_elem_pointlist. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{get_select_bounds()}}{

This function implements the HDF5-API function H5Sget_select_bounds. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{select_all()}}{

This function implements the HDF5-API function H5Sselect_all. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{select_none()}}{

This function implements the HDF5-API function H5Sselect_none. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{select_valid()}}{

This function implements the HDF5-API function H5Sselect_valid. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{select_elements(coord, op = h5const$H5S_SELECT_SET, byrow = TRUE)}}{

This function implements the HDF5-API function H5Sselect_elements. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{select_hyperslab(start, count, stride = NULL, block = NULL,
  op = h5const$H5S_SELECT_SET)}}{

This function implements the HDF5-API function H5Sselect_hyperslab. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}

\item{\code{subset(args, op = h5const$H5S_SELECT_SET, envir = parent.frame())}}{

Subsetting the space. This is mainly intended as a helper function for the '[' function, but
can also be used on its own.

\strong{Parameters}
\describe{
\item{args}{The indices for each dimension to subset given as a list. This makes this easier to use as a programmatic API.
For interactive use we recommend the use of the \code{[} operator.}
\item{op}{The operator to use. Same as for the other HDF5 space selection functions. One of the elements shown in
\code{h5const$H5S_seloper_t}}
\item{envir}{The environment in which to evaluate \code{args}}
}}

\item{\code{print(...)}}{

Prints information for the group

\strong{Parameters}
\describe{
\item{...}{ignored}
}}

\item{\code{dims()}}{

Get the dimensions of the space. Return NULL if the space is not simple (i.e. NULL-space) or a length-0 integer if it is a scalar}

\item{\code{maxdims()}}{

Get the maximal dimensions of the space.Return NULL if the space is not simple (i.e. NULL-space) or a length-0 integer if it is a scalar}

\item{\code{rank()}}{

This function implements the HDF5-API function H5Sget_simple_extent_ndims. Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_s.html} for details.}
}}

\examples{
h5s_fixed <- H5S$new("simple", dims=c(5, 2))
h5s_fixed

h5s_variable <- H5S$new("simple", dims=c(5,2), maxdims=c(Inf,2))
h5s_variable
h5s_variable$set_extent_simple(c(10,2), c(Inf, 2))
h5s_variable

# now select a subset of points
# argument evaluation has a heuristic; here it chooses point selection
h5s_variable[c(1, 3, 8), 1]
h5s_variable$get_select_type()
h5s_variable$get_select_elem_pointlist()

# and a hyperslab (chosen by the argument heuristic)
h5s_variable[2:7, 1:2]
h5s_variable$get_select_type()
h5s_variable$get_select_hyper_blocklist()
}
\author{
Holger Hoefling
}
