% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5R.R
\docType{class}
\name{H5R-class}
\alias{H5R-class}
\alias{H5R}
\title{Class for HDF5 Reference datatypes.}
\value{
Object of class \code{\link[=H5R]{H5R}}.
}
\description{
\code{H5R} is only the common base class and is never used. User should not create objects of this
class by themselves and instead use the \code{create_reference} methods of \code{H5D}, \code{H5Group} or \code{H5File} classes.
Sub-classes are \code{\link{H5R_OBJECT}} and \code{\link{H5R_DATASET_REGION}}
}
\section{Methods}{

\describe{
\item{\code{subset_read(dim_index, drop = TRUE)}}{

Method that returns a subset of the data in the H5R-object

\strong{Parameters}
\describe{
\item{dim_index}{A list of dimension indices as usually pasted into \code{[}}
\item{drop}{Logical. Should dimensions of size 1 be dropped.}
}}

\item{\code{subset2_read(i, exact = TRUE)}}{

Method to read a single item

\strong{Parameters}
\describe{
\item{i}{The single item to read}
\item{exact}{Is the item name exact or should partial matching be allowed?}
}}

\item{\code{subset_assign(dim_index, value)}}{

Assign values into a subset of the H5R-vector

\strong{Parameters}
\describe{
\item{dim_index}{A list of dimension indices as usually passed into \code{[}}
\item{value}{The value to assign}
}}

\item{\code{subset2_assign(i, exact = TRUE, value)}}{

Assign a value to a single value in the array

\strong{Parameters}
\describe{
\item{i}{the index where to assign the value}
\item{value}{The value to assign}
}}

\item{\code{t()}}{

Transpose the object if it is a matrix (i.e. has rank 2}

\item{\code{length()}}{

Get the length of the object}

\item{\code{ref(ref)}}{

Get or assign the internal raw-vector representation of the data. Usually, user's shouldn't have to use this.}

\item{\code{dim(x)}}{

Get or assign the dimensionality of the object}

\item{\code{dimnames(x)}}{

Get or assign the dimnames of the object}

\item{\code{names(x)}}{

Get or assign the names of the object}

\item{\code{rank()}}{

Get the rank of the object}
}}

\examples{
fname <- tempfile(fileext = ".h5")
file <- H5File$new(fname, mode = "a")
file[["testset"]] <- matrix(rnorm(9), nrow = 3)
dset <- file[["testset"]]
r <- file$create_reference("testset")
file$close_all()
}
\author{
Holger Hoefling
}
