/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5B2module.h" 

#include "H5private.h"  
#include "H5B2pkg.h"    
#include "H5Eprivate.h" 

herr_t
H5B2_stat_info(H5B2_t *bt2, H5B2_stat_t *info)
{
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    
    assert(info);

    
    info->depth    = bt2->hdr->depth;
    info->nrecords = bt2->hdr->root.all_nrec;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

herr_t
H5B2_size(H5B2_t *bt2, hsize_t *btree_size)
{
    H5B2_hdr_t *hdr;                 
    herr_t      ret_value = SUCCEED; 

    FUNC_ENTER_NOAPI(FAIL)

    
    assert(bt2);
    assert(btree_size);

    
    bt2->hdr->f = bt2->f;

    
    hdr = bt2->hdr;

    
    *btree_size += hdr->hdr_size;

    
    if (hdr->root.node_nrec > 0) {
        
        if (hdr->depth == 0)
            *btree_size += hdr->node_size;
        else
            
            if (H5B2__node_size(hdr, hdr->depth, &hdr->root, hdr, btree_size) < 0)
                HGOTO_ERROR(H5E_BTREE, H5E_CANTLIST, FAIL, "node iteration failed");
    } 

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
