/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#if !(defined H5PL_FRIEND || defined H5PL_MODULE)
#error "Do not include this file outside the H5PL package!"
#endif
#ifndef H5PLpkg_H
#define H5PLpkg_H
#include "H5PLprivate.h"
#define H5PL_DEFAULT_PATH H5_DEFAULT_PLUGINDIR
#ifdef H5_HAVE_WIN32_API
#define H5PL_PATH_SEPARATOR ";"
#define H5PL_HANDLE HINSTANCE
#define H5PL_OPEN_DLIB(S) LoadLibraryExA(S, NULL, LOAD_WITH_ALTERED_SEARCH_PATH)
#define H5PL_GET_LIB_FUNC(H, N) GetProcAddress(H, N)
#define H5PL_CLOSE_LIB(H) FreeLibrary(H)
#define H5PL_CLR_ERROR
#define H5PL_EXPAND_BUFFER_SIZE 32767
typedef H5PL_type_t(__cdecl *H5PL_get_plugin_type_t)(void);
typedef const void *(__cdecl *H5PL_get_plugin_info_t)(void);
#else
#define H5PL_PATH_SEPARATOR     ":"
#define H5PL_HANDLE             void *
#define H5PL_OPEN_DLIB(S)       dlopen(S, RTLD_LAZY | RTLD_LOCAL)
#define H5PL_GET_LIB_FUNC(H, N) dlsym(H, N)
#define H5PL_CLOSE_LIB(H)       dlclose(H)
#define H5PL_CLR_ERROR          HERROR(H5E_PLUGIN, H5E_CANTGET, "can't dlopen:%s", dlerror())
typedef H5PL_type_t (*H5PL_get_plugin_type_t)(void);
typedef const void *(*H5PL_get_plugin_info_t)(void);
#endif
typedef struct H5PL_search_params_t {
    H5PL_type_t       type;
    const H5PL_key_t *key;
} H5PL_search_params_t;
H5_DLL herr_t H5PL__get_plugin_control_mask(unsigned int *mask);
H5_DLL herr_t H5PL__set_plugin_control_mask(unsigned int mask);
H5_DLL herr_t H5PL__open(const char *libname, H5PL_type_t type, const H5PL_key_t *key, bool *success,
                         H5PL_type_t *plugin_type, const void **plugin_info);
H5_DLL herr_t H5PL__close(H5PL_HANDLE handle);
H5_DLL herr_t H5PL__create_plugin_cache(void);
H5_DLL herr_t H5PL__close_plugin_cache(bool *already_closed);
H5_DLL herr_t H5PL__add_plugin(H5PL_type_t type, const H5PL_key_t *key, H5PL_HANDLE handle);
H5_DLL herr_t H5PL__find_plugin_in_cache(const H5PL_search_params_t *search_params, bool *found,
                                         const void **plugin_info);
H5_DLL herr_t      H5PL__create_path_table(void);
H5_DLL herr_t      H5PL__close_path_table(void);
H5_DLL unsigned    H5PL__get_num_paths(void);
H5_DLL herr_t      H5PL__append_path(const char *path);
H5_DLL herr_t      H5PL__prepend_path(const char *path);
H5_DLL herr_t      H5PL__replace_path(const char *path, unsigned int index);
H5_DLL herr_t      H5PL__insert_path(const char *path, unsigned int index);
H5_DLL herr_t      H5PL__remove_path(unsigned int index);
H5_DLL const char *H5PL__get_path(unsigned int index);
H5_DLL herr_t H5PL__path_table_iterate(H5PL_iterate_type_t iter_type, H5PL_iterate_t iter_op, void *op_data);
H5_DLL herr_t H5PL__find_plugin_in_path_table(const H5PL_search_params_t *search_params, bool *found,
                                              const void **plugin_info);
#endif
