// (c) The HDF Group
#if !(defined H5O_FRIEND || defined H5O_MODULE)
#error "Do not include this file outside the H5O package!"
#endif
#ifndef H5Opkg_H
#define H5Opkg_H
#include "H5Oprivate.h"
#include "H5ACprivate.h"
#include "H5FLprivate.h"
#define H5O_NMESGS  8
#define H5O_NCHUNKS 2
#define H5O_MIN_SIZE                                                                                         \
    22
#define H5O_MSG_TYPES         26
#define H5O_MAX_CRT_ORDER_IDX 65535
#define H5O_VERSION_1 1
#define H5O_VERSION_2 2
#define H5O_VERSION_LATEST H5O_VERSION_2
#define H5O_ALIGN_OLD(X)     (8 * (((X) + 7) / 8))
#define H5O_ALIGN_VERS(V, X) (((V) == H5O_VERSION_1) ? H5O_ALIGN_OLD(X) : (X))
#define H5O_ALIGN_OH(O, X)   H5O_ALIGN_VERS((O)->version, X)
#define H5O_ALIGN_F(F, X)    H5O_ALIGN_VERS(MAX(H5O_VERSION_1, (uint8_t)H5O_obj_ver_bounds[H5F_LOW_BOUND(F)]), X)
#define H5O_SIZEOF_CHKSUM 4
#define H5O_CRT_ATTR_MAX_COMPACT_DEF 8
#define H5O_CRT_ATTR_MIN_DENSE_DEF   6
#define H5O_CRT_OHDR_FLAGS_DEF       H5O_HDR_STORE_TIMES
#define H5O_HDR_CHUNK0_1 0x00
#define H5O_HDR_CHUNK0_2 0x01
#define H5O_HDR_CHUNK0_4 0x02
#define H5O_HDR_CHUNK0_8 0x03
#define H5O_SIZEOF_HDR(O)                                                                                    \
    (((O)->version == H5O_VERSION_1)                                                                         \
         ? H5O_ALIGN_OLD(1 +                                   \
                         1 +                                       \
                         2 +                               \
                         4 +                                  \
                         4)                                  \
         : (H5_SIZEOF_MAGIC +                                   \
            1 +                                  \
            1 +                                         \
            (((O)->flags & H5O_HDR_STORE_TIMES) ? (4 +                                     \
                                                   4 +                                \
                                                   4 +                                     \
                                                   4                                      \
                                                   )                                                         \
                                                : 0) +                                                       \
            (((O)->flags & H5O_HDR_ATTR_STORE_PHASE_CHANGE) ? (2 +               \
                                                               2                 \
                                                               )                                             \
                                                            : 0) +                                           \
            (1 << ((O)->flags & H5O_HDR_CHUNK0_SIZE)) +                               \
            H5O_SIZEOF_CHKSUM)                                   \
    )
#define H5O_SIZEOF_MSGHDR_VERS(V, C)                                                                         \
    (((V) == H5O_VERSION_1) ? H5O_ALIGN_OLD(2 +                                           \
                                            2 +                                     \
                                            1 +                                     \
                                            3)                                               \
                            : (1 +                                           \
                               2 +                                     \
                               1 +                                     \
                               ((C) ? (2                                     \
                                       )                                                                     \
                                    : 0)))
#define H5O_SIZEOF_MSGHDR_OH(O)                                                                              \
    (unsigned)H5O_SIZEOF_MSGHDR_VERS((O)->version, (O)->flags &H5O_HDR_ATTR_CRT_ORDER_TRACKED)
#define H5O_SIZEOF_MSGHDR_F(F, C)                                                                            \
    (unsigned)H5O_SIZEOF_MSGHDR_VERS(MAX((H5F_STORE_MSG_CRT_IDX(F) ? H5O_VERSION_LATEST : H5O_VERSION_1),    \
                                         (uint8_t)H5O_obj_ver_bounds[H5F_LOW_BOUND(F)]),                     \
                                     (C))
#define H5O_SIZEOF_CHKHDR_VERS(V)                                                                            \
    (((V) == H5O_VERSION_1) ? 0 +                                         \
                                  0                                         \
                            : H5_SIZEOF_MAGIC +                                            \
                                  H5O_SIZEOF_CHKSUM                                            \
    )
#define H5O_SIZEOF_CHKHDR_OH(O) H5O_SIZEOF_CHKHDR_VERS((O)->version)
#define H5O_SIZEOF_CHKSUM_VERS(V)                                                                            \
    (((V) == H5O_VERSION_1) ? 0                                             \
                            : H5O_SIZEOF_CHKSUM                                                \
    )
#define H5O_SIZEOF_CHKSUM_OH(O) H5O_SIZEOF_CHKSUM_VERS((O)->version)
#define H5O_DECODEIO_NOCHANGE 0x01u
#define H5O_DECODEIO_DIRTY    0x02u
#define H5O_DECODEIO_RFIC_UNUBNT                                                                             \
    0x04u
#ifndef NDEBUG
#define INCR_NDECODE_DIRTIED(OH) (OH)->ndecode_dirtied++;
#else
#define INCR_NDECODE_DIRTIED(OH) ;
#endif
#define H5O_LOAD_NATIVE(F, IOF, OH, MSG, ERR)                                                                \
    if (NULL == (MSG)->native) {                                                                             \
        const H5O_msg_class_t *msg_type = (MSG)->type;                                                       \
        unsigned               ioflags  = (IOF);                                                             \
                                                                                                             \
                                                                             \
        assert(msg_type->decode);                                                                            \
        if (NULL == ((MSG)->native = (msg_type->decode)((F), (OH), (MSG)->flags, &ioflags, (MSG)->raw_size,  \
                                                        (MSG)->raw)))                                        \
            HGOTO_ERROR(H5E_OHDR, H5E_CANTDECODE, ERR, "unable to decode message");                          \
                                                                                                             \
                                           \
        if ((ioflags & H5O_DECODEIO_DIRTY) && (H5F_get_intent((F)) & H5F_ACC_RDWR)) {                        \
            (MSG)->dirty = true;                                                                             \
                                   \
                                                                         \
            INCR_NDECODE_DIRTIED(OH)                                                                         \
        }                                                                                                    \
                                                                                                             \
                                             \
        if ((MSG)->flags & H5O_MSG_FLAG_SHAREABLE) {                                                         \
            assert(msg_type->share_flags &H5O_SHARE_IS_SHARABLE);                                            \
            H5O_UPDATE_SHARED((H5O_shared_t *)(MSG)->native, H5O_SHARE_TYPE_HERE, (F), msg_type->id,         \
                              (MSG)->crt_idx, (OH)->chunk[0].addr)                                           \
        }                                                                                       \
                                                                                                             \
                                              \
        if (msg_type->set_crt_index) {                                                                       \
                                                     \
            if ((msg_type->set_crt_index)((MSG)->native, (MSG)->crt_idx) < 0)                                \
                HGOTO_ERROR(H5E_OHDR, H5E_CANTSET, ERR, "unable to set creation index");                     \
        }                                                                                       \
    }
#define H5O_SHARE_IS_SHARABLE 0x01
#define H5O_SHARE_IN_OHDR     0x02
#define H5O_SPEC_READ_SIZE 512
struct H5O_msg_class_t {
    unsigned    id;
    const char *name;
    size_t      native_size;
    unsigned    share_flags;
    void *(*decode)(H5F_t *, H5O_t *, unsigned, unsigned *, size_t, const uint8_t *);
    herr_t (*encode)(H5F_t *, bool, size_t, uint8_t *, const void *);
    void *(*copy)(const void *, void *);
    size_t (*raw_size)(const H5F_t *, bool, const void *);
    herr_t (*reset)(void *);
    herr_t (*free)(void *);
    herr_t (*del)(H5F_t *, H5O_t *, void *);
    herr_t (*link)(H5F_t *, H5O_t *, void *);
    herr_t (*set_share)(void *, const H5O_shared_t *);
    htri_t (*can_share)(const void *);
    herr_t (*pre_copy_file)(H5F_t *, const void *, bool *, const H5O_copy_t *,
                            void *);
    void *(*copy_file)(H5F_t *, void *, H5F_t *, bool *, unsigned *, H5O_copy_t *,
                       void *);
    herr_t (*post_copy_file)(const H5O_loc_t *, const void *, H5O_loc_t *, void *, unsigned *,
                             H5O_copy_t *);
    herr_t (*get_crt_index)(const void *, H5O_msg_crt_idx_t *);
    herr_t (*set_crt_index)(void *, H5O_msg_crt_idx_t);
    herr_t (*debug)(H5F_t *, const void *, FILE *, int, int);
};
struct H5O_mesg_t {
    const H5O_msg_class_t *type;
    bool                   dirty;
    uint8_t                flags;
    H5O_msg_crt_idx_t      crt_idx;
    unsigned               chunkno;
    void                  *native;
    uint8_t               *raw;
    size_t                 raw_size;
};
typedef struct H5O_msg_alloc_info_t {
    int      msgno;
    unsigned id;
    unsigned chunkno;
    size_t   gap_size;
    size_t   null_size;
    size_t   total_size;
    unsigned null_msgno;
} H5O_msg_alloc_info_t;
typedef struct H5O_chunk_t {
    haddr_t                   addr;
    size_t                    size;
    size_t                    gap;
    uint8_t                  *image;
    struct H5O_chunk_proxy_t *chunk_proxy;
} H5O_chunk_t;
struct H5O_t {
    H5AC_info_t cache_info;
    size_t sizeof_size;
    size_t sizeof_addr;
    bool   swmr_write;
#ifdef H5O_ENABLE_BAD_MESG_COUNT
    bool store_bad_mesg_count;
#endif
#ifndef NDEBUG
    size_t ndecode_dirtied;
#endif
    size_t rc;
    bool     has_refcount_msg;
    unsigned nlink;
    uint8_t  version;
    uint8_t  flags;
    time_t atime;
    time_t mtime;
    time_t ctime;
    time_t btime;
    unsigned max_compact;
    unsigned min_dense;
    size_t      nmesgs;
    size_t      alloc_nmesgs;
    H5O_mesg_t *mesg;
    size_t      link_msgs_seen;
    size_t      attr_msgs_seen;
    size_t       nchunks;
    size_t       alloc_nchunks;
    H5O_chunk_t *chunk;
    bool         chunks_pinned;
    H5AC_proxy_entry_t *proxy;
};
typedef struct H5O_obj_class_t {
    H5O_type_t  type;
    const char *name;
    void *(*get_copy_file_udata)(void);
    void (*free_copy_file_udata)(void *);
    htri_t (*isa)(const H5O_t *);
    void *(*open)(const H5G_loc_t *, H5I_type_t *);
    void *(*create)(H5F_t *, void *, H5G_loc_t *);
    H5O_loc_t *(*get_oloc)(hid_t);
    herr_t (*bh_info)(const H5O_loc_t *loc, H5O_t *oh,
                      H5_ih_info_t *bh_info);
    herr_t (*flush)(void *obj_ptr);
} H5O_obj_class_t;
typedef struct H5O_addr_map_t {
    H5_obj_t               src_obj_pos;
    haddr_t                dst_addr;
    bool                   is_locked;
    hsize_t                inc_ref_count;
    const H5O_obj_class_t *obj_class;
    void                  *udata;
} H5O_addr_map_t;
typedef struct H5O_cont_msgs_t {
    size_t      nmsgs;
    size_t      alloc_nmsgs;
    H5O_cont_t *msgs;
} H5O_cont_msgs_t;
typedef struct H5O_common_cache_ud_t {
    H5F_t           *f;
    unsigned         file_intent;
    unsigned         merged_null_msgs;
    H5O_cont_msgs_t *cont_msg_info;
    haddr_t          addr;
} H5O_common_cache_ud_t;
typedef struct H5O_cache_ud_t {
    bool                  made_attempt;
    unsigned              v1_pfx_nmesgs;
    size_t                chunk0_size;
    H5O_t                *oh;
    uint8_t               oh_version;
    H5O_common_cache_ud_t common;
} H5O_cache_ud_t;
typedef struct H5O_chunk_proxy_t {
    H5AC_info_t cache_info;
    H5F_t   *f;
    H5O_t   *oh;
    unsigned chunkno;
    void *fd_parent;
} H5O_chunk_proxy_t;
typedef struct H5O_chk_cache_ud_t {
    bool                  decoding;
    H5O_t                *oh;
    unsigned              chunkno;
    size_t                size;
    H5O_common_cache_ud_t common;
} H5O_chk_cache_ud_t;
H5_DLLVAR const H5O_msg_class_t *const H5O_msg_class_g[H5O_MSG_TYPES];
H5FL_EXTERN(H5O_t);
H5FL_SEQ_EXTERN(H5O_mesg_t);
H5FL_SEQ_EXTERN(H5O_chunk_t);
H5FL_BLK_EXTERN(chunk_image);
H5_DLLVAR const H5O_msg_class_t H5O_MSG_NULL[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_SDSPACE[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_LINFO[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_DTYPE[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_FILL[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_FILL_NEW[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_LINK[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_EFL[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_LAYOUT[1];
#ifdef H5O_ENABLE_BOGUS
H5_DLLVAR const H5O_msg_class_t H5O_MSG_BOGUS_VALID[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_BOGUS_INVALID[1];
#endif
H5_DLLVAR const H5O_msg_class_t H5O_MSG_GINFO[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_PLINE[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_ATTR[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_NAME[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_MTIME[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_SHMESG[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_CONT[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_STAB[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_MTIME_NEW[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_BTREEK[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_DRVINFO[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_AINFO[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_REFCOUNT[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_FSINFO[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_MDCI[1];
H5_DLLVAR const H5O_msg_class_t H5O_MSG_UNKNOWN[1];
H5_DLLVAR const H5O_obj_class_t H5O_OBJ_GROUP[1];
H5_DLLVAR const H5O_obj_class_t H5O_OBJ_DATASET[1];
H5_DLLVAR const H5O_obj_class_t H5O_OBJ_DATATYPE[1];
H5_DLL void *H5O__open_by_addr(const H5G_loc_t *loc, haddr_t addr, H5I_type_t *opened_type);
H5_DLL void *H5O__open_by_idx(const H5G_loc_t *loc, const char *name, H5_index_t idx_type,
                              H5_iter_order_t order, hsize_t n, H5I_type_t *opened_type);
H5_DLL const H5O_obj_class_t *H5O__obj_class(const H5O_loc_t *loc);
H5_DLL herr_t                 H5O__copy(const H5G_loc_t *src_loc, const char *src_name, H5G_loc_t *dst_loc,
                                        const char *dst_name, hid_t ocpypl_id, hid_t lcpl_id);
H5_DLL int                    H5O__link_oh(H5F_t *f, int adjust, H5O_t *oh, bool *deleted);
H5_DLL herr_t H5O__visit(H5G_loc_t *loc, const char *obj_name, H5_index_t idx_type, H5_iter_order_t order,
                         H5O_iterate2_t op, void *op_data, unsigned fields);
H5_DLL herr_t H5O__inc_rc(H5O_t *oh);
H5_DLL herr_t H5O__dec_rc(H5O_t *oh);
H5_DLL herr_t H5O__free(H5O_t *oh, bool force);
H5_DLL herr_t   H5O__msg_alloc(H5F_t *f, H5O_t *oh, const H5O_msg_class_t *type, unsigned *mesg_flags,
                               void *mesg, size_t *mesg_idx);
H5_DLL herr_t   H5O__msg_append_real(H5F_t *f, H5O_t *oh, const H5O_msg_class_t *type, unsigned mesg_flags,
                                     unsigned update_flags, void *mesg);
H5_DLL herr_t   H5O__msg_write_real(H5F_t *f, H5O_t *oh, const H5O_msg_class_t *type, unsigned mesg_flags,
                                    unsigned update_flags, void *mesg);
H5_DLL herr_t   H5O__msg_free_mesg(H5O_mesg_t *mesg);
H5_DLL unsigned H5O__msg_count_real(const H5O_t *oh, const H5O_msg_class_t *type);
H5_DLL herr_t   H5O__msg_remove_real(H5F_t *f, H5O_t *oh, const H5O_msg_class_t *type, int sequence,
                                     H5O_operator_t op, void *op_data, bool adj_link);
H5_DLL void *H5O__msg_copy_file(const H5O_msg_class_t *type, H5F_t *file_src, void *mesg_src, H5F_t *file_dst,
                                bool *recompute_size, unsigned *mesg_flags, H5O_copy_t *cpy_info,
                                void *udata);
H5_DLL herr_t H5O__msg_iterate_real(H5F_t *f, H5O_t *oh, const H5O_msg_class_t *type,
                                    const H5O_mesg_operator_t *op, void *op_data);
H5_DLL herr_t H5O__flush_msgs(H5F_t *f, H5O_t *oh);
H5_DLL herr_t H5O__delete_mesg(H5F_t *f, H5O_t *open_oh, H5O_mesg_t *mesg);
H5_DLL herr_t             H5O__chunk_add(H5F_t *f, H5O_t *oh, unsigned idx, unsigned cont_chunkno);
H5_DLL H5O_chunk_proxy_t *H5O__chunk_protect(H5F_t *f, H5O_t *oh, unsigned idx);
H5_DLL herr_t             H5O__chunk_unprotect(H5F_t *f, H5O_chunk_proxy_t *chk_proxy, bool chk_dirtied);
H5_DLL herr_t             H5O__chunk_update_idx(H5F_t *f, H5O_t *oh, unsigned idx);
H5_DLL herr_t             H5O__chunk_resize(H5O_t *oh, H5O_chunk_proxy_t *chk_proxy);
H5_DLL herr_t             H5O__chunk_delete(H5F_t *f, H5O_t *oh, unsigned idx);
H5_DLL herr_t             H5O__chunk_dest(H5O_chunk_proxy_t *chunk_proxy);
H5_DLL herr_t H5O__disable_mdc_flushes(H5O_loc_t *oloc);
H5_DLL herr_t H5O__enable_mdc_flushes(H5O_loc_t *oloc);
H5_DLL herr_t H5O__are_mdc_flushes_disabled(const H5O_loc_t *oloc, bool *are_disabled);
H5_DLL herr_t H5O__attr_bh_info(H5F_t *f, H5O_t *oh, H5_ih_info_t *bh_info);
H5_DLL herr_t H5O__alloc_msgs(H5O_t *oh, size_t min_alloc);
H5_DLL herr_t H5O__alloc_chunk(H5F_t *f, H5O_t *oh, size_t size, size_t found_null,
                               const H5O_msg_alloc_info_t *found_msg, size_t *new_idx);
H5_DLL herr_t H5O__alloc(H5F_t *f, H5O_t *oh, const H5O_msg_class_t *type, const void *mesg,
                         size_t *mesg_idx);
H5_DLL herr_t H5O__condense_header(H5F_t *f, H5O_t *oh);
H5_DLL herr_t H5O__release_mesg(H5F_t *f, H5O_t *oh, H5O_mesg_t *mesg, bool adj_link);
H5_DLL void  *H5O__shared_decode(H5F_t *f, H5O_t *open_oh, unsigned *ioflags, size_t buf_size,
                                 const uint8_t *buf, const H5O_msg_class_t *type);
H5_DLL herr_t H5O__shared_encode(const H5F_t *f, uint8_t *buf, const H5O_shared_t *sh_mesg);
H5_DLL size_t H5O__shared_size(const H5F_t *f, const H5O_shared_t *sh_mesg);
H5_DLL herr_t H5O__shared_delete(H5F_t *f, H5O_t *open_oh, const H5O_msg_class_t *mesg_type,
                                 H5O_shared_t *sh_mesg);
H5_DLL herr_t H5O__shared_link(H5F_t *f, H5O_t *open_oh, const H5O_msg_class_t *mesg_type,
                               H5O_shared_t *sh_mesg);
H5_DLL herr_t H5O__shared_copy_file(H5F_t *file_src, H5F_t *file_dst, const H5O_msg_class_t *mesg_type,
                                    const void *_native_src, void *_native_dst, bool *recompute_size,
                                    unsigned *mesg_flags, H5O_copy_t *cpy_info, void *udata);
H5_DLL herr_t H5O__shared_post_copy_file(H5F_t *f, const H5O_msg_class_t *mesg_type,
                                         const H5O_shared_t *shared_src, H5O_shared_t *shared_dst,
                                         unsigned *mesg_flags, H5O_copy_t *cpy_info);
H5_DLL herr_t H5O__shared_debug(const H5O_shared_t *mesg, FILE *stream, int indent, int fwidth);
H5_DLL herr_t H5O__attr_reset(void *_mesg);
H5_DLL herr_t H5O__attr_delete(H5F_t *f, H5O_t *open_oh, void *_mesg);
H5_DLL herr_t H5O__attr_link(H5F_t *f, H5O_t *open_oh, void *_mesg);
H5_DLL herr_t H5O__attr_count_real(H5F_t *f, H5O_t *oh, hsize_t *nattrs);
H5_DLLVAR const unsigned H5O_obj_ver_bounds[H5F_LIBVER_NBOUNDS];
H5_DLLVAR const unsigned H5O_attr_ver_bounds[H5F_LIBVER_NBOUNDS];
H5_DLLVAR const unsigned H5O_fill_ver_bounds[H5F_LIBVER_NBOUNDS];
H5_DLLVAR const unsigned H5O_pline_ver_bounds[H5F_LIBVER_NBOUNDS];
#ifdef H5O_TESTING
H5_DLL htri_t H5O__is_attr_empty_test(hid_t oid);
H5_DLL htri_t H5O__is_attr_dense_test(hid_t oid);
H5_DLL herr_t H5O__num_attrs_test(hid_t oid, hsize_t *nattrs);
H5_DLL herr_t H5O__attr_dense_info_test(hid_t oid, hsize_t *name_count, hsize_t *corder_count);
H5_DLL herr_t H5O__check_msg_marked_test(hid_t oid, bool flag_val);
H5_DLL herr_t H5O__expunge_chunks_test(const H5O_loc_t *oloc);
H5_DLL herr_t H5O__get_rc_test(const H5O_loc_t *oloc, unsigned *rc);
H5_DLL herr_t H5O__msg_get_chunkno_test(hid_t oid, unsigned msg_type, unsigned *chunk_num);
H5_DLL herr_t H5O__msg_move_to_new_chunk_test(hid_t oid, unsigned msg_type);
#endif
#ifdef H5O_DEBUG
H5_DLL herr_t H5O__assert(const H5O_t *oh);
#endif
H5_DLL herr_t H5O__debug_real(H5F_t *f, H5O_t *oh, haddr_t addr, FILE *stream, int indent, int fwidth);
#endif
