% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minWO.R
\name{minWO}
\alias{minWO}
\title{Minimum detectable or WO for alternative hypothesis for given power (no ties)}
\usage{
minWO(N, power = 0.5, SD = NULL, k = 0.5, alpha = 0.05, WOnull = 1, digits = 2)
}
\arguments{
\item{N}{a numeric vector of sample size values (two arms combined).}

\item{power}{the given power. The default is 0.5 corresponding to the minimum detectable win odds. A numeric vector of length 1.}

\item{SD}{assumed standard deviation of the win proportion. By default uses the conservative SD. A numeric vector of length 1.}

\item{k}{proportion of active group in the overall sample size. Default is 0.5 (balanced randomization). A numeric vector of length 1.}

\item{alpha}{the significance level for the 2-sided test. Default is 0.05. A numeric vector of length 1.}

\item{WOnull}{the win odds value of the null hypothesis (default is 1). A numeric vector of length 1.}

\item{digits}{precision to use for reporting calculated win odds.}
}
\value{
a data frame containing the calculated WO with input values.
}
\description{
Minimum detectable or WO for alternative hypothesis for given power (no ties)
}
\examples{
minWO(N = 100, digits = 5)
minWO(N = 1200, power = 0.9, k = 0.75)
# Compare the minimum detectable win odds from shifted alternatives to max and ordered alternatives
WO <- minWO(N = 1200, k = 0.5, power = 0.67, digits = 7)$WO
powerWO(N = 1200, WO = WO, k = 0.5, alternative = "shift")
powerWO(N = 1200, WO = WO, k = 0.5, alternative = "ordered")
powerWO(N = 1200, WO = WO, k = 0.5, alternative = "max")
}
\references{
Gasparyan SB et al. (2021) "Power and sample size calculation for the win odds test: application to an ordinal endpoint in COVID-19 trials." Journal of Biopharmaceutical Statistics 31.6: 765-787. \url{doi:10.1080/10543406.2021.1968893}
}
\seealso{
\code{\link[=powerWO]{powerWO()}}, \code{\link[=sizeWO]{sizeWO()}}  for WO power and sample size calculation.
}
