% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_est.R
\name{get_est}
\alias{get_est}
\title{Extract point estimates or other summaries of marginal posterior distributions}
\usage{
get_est(
  object,
  par = "theta",
  format_orig = FALSE,
  probs = c(0.025, 0.5, 0.975),
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{stanfit} produced by \code{hbam()}, or a list produced by \code{fbam()}.}

\item{par}{Character: Name of the parameter type to be extracted. Typically \code{"theta"} (stimuli positions) or \code{"chi"} (respondent positions).}

\item{format_orig}{Logical: Should individual-level parameters be mapped to the original dataset by returning rows of NAs for respondents who were not included in the analysis? Defaults to \code{FALSE}.}

\item{probs}{A numeric vector of quantiles of interest for summarizing \code{stanfit} objects.}

\item{simplify}{Logical: Should the returned object be simplified by dropping the Monte Carlo standard error and the posterior standard deviation? Defaults to \code{TRUE}.}

\item{...}{Other arguments are passed on to \code{rstan::summary()} when summarizing \code{stanfit} objects.}
}
\value{
A tibble containing summaries of marginal posterior distributions. For objects produced by \code{fbam()}, only maximum a posteriori estimates are returned.
}
\description{
For objects produced by \code{hbam()}, this function is a wrapper for \code{rstan::summary()}. For objects produced by \code{fbam()} it offers a way to extract point estimates.
}
