\name{has.key-methods}
\docType{methods}
\alias{has.key-methods}
\alias{has.key,ANY,hash-method}
\title{  Test for existence of a hash entry }
\description{
    \code{has.key} returns a logical vector of the length of key, indicating
    if the key is defined on the hash.
}

\section{Methods}{
    \describe{

        \item{key = "ANY", hash = "hash"}{ 
          test for the existence of hash entries, key 
        }
    }
}    


\arguments{
  \item{key}{ A vector whose entries will be coerced to valid keys. }
  \item{hash}{ A \code{\link{hash}} object. }
  \item{...}{ arguments passed to further functions }
}

\details{}

\value{
  \item{logical}{A logical vector of length \code{key} indicating whether
  the key is defined in the hash. }
}
\author{ Christopher Brown }
\seealso{ See Also as \code{\link{hash}}, ~~~ }

\examples{
    h <- hash( letters, 1:26 )
    all( has.key( letters, h ) ) # TRUE
}

\keyword{ methods }
\keyword{ data }
\keyword{ manip }
